/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.config.JstProperties;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.exception.JstApiException;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.spi.InvIdoJstCallback;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class JstService {
    private static final Logger log = LoggerFactory.getLogger(JstService.class);
    private static final String SIGN_METHOD_MD5 = "md5";
    private static final String CHARSET_UTF8 = "utf-8";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private final JstProperties jstProperties;
    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectProvider<InvIdoJstCallback> invIdoJstCallbackObjectProvider;

    public String getSellerItem(String param, String url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", this.jstProperties.getAppKey());
        params.put("access_token", this.jstProperties.getAccessToken());
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", CHARSET_UTF8);
        params.put("biz", param);
        params.put("sign", this.signTopRequest(params, this.jstProperties.getAppSecret(), SIGN_METHOD_MD5));
        return this.callApi(new URL(this.jstProperties.getServerUrl() + url), params);
    }

    public JushuitanBaseResponse getSellerItem(String param, String url, String pushRecordInterType, Long docId, String docNo) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", this.jstProperties.getAppKey());
        params.put("access_token", this.jstProperties.getAccessToken());
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", CHARSET_UTF8);
        params.put("biz", param);
        params.put("sign", this.signTopRequest(params, this.jstProperties.getAppSecret(), SIGN_METHOD_MD5));
        return this.callApi(new URL(this.jstProperties.getServerUrl() + url), params, pushRecordInterType, docId, docNo);
    }

    public static PurchaseInboundResponse convertToPurchaseInboundResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        PurchaseInboundResponse response = new PurchaseInboundResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                List purchaseData = JSON.parseArray((String)dataJson, PurchaseInboundResponse.PurchaseInboundData.class);
                response.setData(purchaseData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u91c7\u8d2d\u5165\u5e93\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    private String signTopRequest(Map<String, String> params, String secret, String signMethod) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if (SIGN_METHOD_MD5.equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!this.isNotEmpty((String)key) || !this.isNotEmpty(value)) continue;
            query.append((String)key).append(value);
        }
        return this.createSign(query.toString());
    }

    private String createSign(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(SIGN_METHOD_MD5);
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String callApi(URL url, Map<String, String> params) throws IOException {
        String query = this.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            rsp = this.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public JushuitanBaseResponse callApi(URL url, Map<String, String> params, String pushRecordInterType, Long docId, String docNo) throws IOException {
        if (!this.jstProperties.getEnabled().booleanValue()) {
            log.warn("JST\u63a5\u53e3\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u8c03\u7528");
            JushuitanBaseResponse response = new JushuitanBaseResponse();
            response.setCode(99999);
            response.setMsg("JST\u63a5\u53e3\u672a\u542f\u7528");
            return response;
        }
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody(params);
        String query = this.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            JushuitanBaseResponse response;
            block17: {
                PurchaseInboundResponse purchaseInboundResponse;
                block18: {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Host", url.getHost());
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
                    out = conn.getOutputStream();
                    out.write(content);
                    String rspStr = this.getResponseAsString(conn);
                    if (!StringUtils.hasText((String)rspStr)) {
                        throw new NcApiException("YST\u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94");
                    }
                    try {
                        List failedMessage;
                        response = (JushuitanBaseResponse)JSON.parseObject((String)rspStr, JushuitanBaseResponse.class);
                        pushRecordDTO.setRespBody((Object)response);
                        if (response == null) {
                            log.error("JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr);
                            throw new NcApiException("JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25");
                        }
                        log.info("JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u7ed3\u679c: \u54cd\u5e94\u7f16\u7801={}, \u54cd\u5e94\u6d88\u606f={}, \u6d88\u606f\u7c7b\u578b={}, \u8bf7\u6c42ID={}", new Object[]{response.getCode(), response.getMsg(), response.getMsg_type(), response.getRequest_id()});
                        if (!response.isSuccess()) {
                            String errorMessage = response.getMsg();
                            pushRecordDTO.setErrorMsg(errorMessage);
                            log.error("JST\u63a5\u53e3\u8c03\u7528\u5931\u8d25: {}", (Object)errorMessage);
                            throw new JstApiException(response.getCode(), errorMessage, response.getMsg_type(), response.getRequest_id());
                        }
                        if (!OutsidePushInter.INV_IDO_SYNC_TO_JST.name().equals(pushRecordInterType)) break block17;
                        purchaseInboundResponse = JstService.convertToPurchaseInboundResponse(response);
                        if (!purchaseInboundResponse.isSuccess() || purchaseInboundResponse.getData() == null || CollectionUtils.isEmpty((Collection)((Collection)purchaseInboundResponse.getData())) || (failedMessage = ((List)purchaseInboundResponse.getData()).stream().filter(data -> !Boolean.TRUE.equals(data.getIs_success())).map(PurchaseInboundResponse.PurchaseInboundData::getMessage).collect(Collectors.toList())).isEmpty()) break block18;
                        String errorMsg = String.join((CharSequence)",", failedMessage);
                        log.warn("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u90e8\u5206\u5165\u5e93\u5355\u521b\u5efa\u5931\u8d25 | \u5931\u8d25\u7684\u5916\u90e8\u5355\u53f7: {}", (Object)errorMsg);
                        pushRecordDTO.setReqSuccess(false);
                        pushRecordDTO.setErrorMsg(errorMsg);
                        this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                        JushuitanBaseResponse jushuitanBaseResponse = response;
                        return jushuitanBaseResponse;
                    }
                    catch (JSONException e) {
                        try {
                            log.error("JST\u63a5\u53e3\u54cd\u5e94JSON\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr, (Object)e);
                            pushRecordDTO.setErrorMsg(e.getMessage());
                            pushRecordDTO.setReqSuccess(false);
                            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                            throw new JstApiException("JST\u63a5\u53e3\u54cd\u5e94\u683c\u5f0f\u9519\u8bef: " + e.getMessage(), e);
                        }
                        catch (Exception e2) {
                            log.error("jst\u63a8\u9001\u5931\u8d25", (Throwable)e2);
                            pushRecordDTO.setErrorMsg(e2.getMessage());
                            pushRecordDTO.setReqSuccess(false);
                            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                            throw new JstApiException(9999, e2.getMessage(), "ee", "eee");
                        }
                    }
                }
                for (InvIdoJstCallback invIdoJstCallback : this.invIdoJstCallbackObjectProvider) {
                    invIdoJstCallback.callback(purchaseInboundResponse);
                }
            }
            pushRecordDTO.setReqSuccess(true);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.info("JST\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            JushuitanBaseResponse jushuitanBaseResponse = response;
            return jushuitanBaseResponse;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!this.isNotEmpty(name) || !this.isNotEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = this.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return this.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return this.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String getResponseCharset(String ctype) {
        String charset = CHARSET_UTF8;
        if (this.isNotEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || !this.isNotEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public JstService(JstProperties jstProperties, OutsidePushRecordRepository outsidePushRecordRepository) {
        this.jstProperties = jstProperties;
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

