/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.util;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class DateTimeUtils {
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static LocalDateTime stringToTime(String timeStr) {
        return LocalDateTime.parse(timeStr, DEFAULT_DATETIME_FORMATTER);
    }

    public static LocalDateTime timeOffset(LocalDateTime time, long offset, TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS: {
                time = time.plusSeconds(offset / 1000L);
                break;
            }
            case SECONDS: {
                time = time.plusSeconds(offset);
                break;
            }
            case MINUTES: {
                time = time.plusMinutes(offset);
                break;
            }
            case HOURS: {
                time = time.plusHours(offset);
                break;
            }
            case DAYS: {
                time = time.plusDays(offset);
            }
        }
        String newDate = time.format(DEFAULT_DATETIME_FORMATTER);
        return DateTimeUtils.stringToTime(newDate);
    }

    public static long getTimestamp() {
        return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }
}

