package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erppackagegoodsimport;



import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.core.PackageSku;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.core.SkuInfo;

import java.math.BigDecimal;
import java.util.List;

public class ErpPackageGoodsImportRequestBizData extends BaseRequestBizData {
    /**
     * 货品名称
     */
    private String goodsName;

    /**
     * 货品英文名
     */
    private String goodsNameEn;

    /**
     * 货品编号，如果名字不存在编号存在则按编号更新
     */
    private String goodsNo;

    /**
     * 货品别名
     */
    private String goodsAlias;

    /**
     * 货品分类编码
     */
    private String cateCode;

    /**
     * 货品的分类名称
     */
    private String cateName;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 货品备注
     */
    private String goodsMemo;

    /**
     * 货品说明
     */
    private String goodsDesc;

    /**
     * 质保期，如果是有效期管理，此项必输
     */
    private BigDecimal shelfLife;

    /**
     * 质保期的单位(年、月、天)，如果是有效期管理，此项必输
     */
    private String shelfLiftUnit;

    /**
     * 计价方式0=移动加权平均1=先进先出2=个别计价3=月末一次加权平均法4=固定成本价5=批内移动加权平均
     */
    private Integer costValuationMethod;

    /**
     * 是否序列号管理
     */
    private Integer isBatchManagement;

    /**
     * 有效期管理
     */
    private Integer isSerialManagement;

    /**
     * 货品属性1-成品2-半成品3-原料4-包装材料
     */
    private Integer isPeriodManage;

    /**
     * 预售品（转预售单）1-是0-否
     */
    private Integer goodsAttr;

    /**
     * 代销（转供应商发货）1-是0-否
     */
    private Integer isProsaleProduct;

    /**
     * 定制生产（转生产后发货）1-是0-否
     */
    private Integer isProxySale;

    /**
     * 需上门安装（发货后转工单)1-是0-否
     */
    private Integer isCustomizProduction;

    /**
     * 有偿服务（无库存管理）1-是0-否
     */
    private Integer isDoorService;

    /**
     * 提货卡券（提货结算冲抵）1-是0-否
     */
    private Integer isPaidService;

    /**
     * 生产物料1-是 0-否
     */
    private Integer isPickupCard;

    /**
     *
     */
    private Integer isProductionMaterials;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 规格明细，没有明细则自动生成“默认规格”的sku
     */
    private List<SkuInfo> skuList;

    /**
     * 组合装的子件列表
     */
    private List<PackageSku> packageSkuList;

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsNameEn() {
        return goodsNameEn;
    }

    public void setGoodsNameEn(String goodsNameEn) {
        this.goodsNameEn = goodsNameEn;
    }

    public String getGoodsNo() {
        return goodsNo;
    }

    public void setGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
    }

    public String getGoodsAlias() {
        return goodsAlias;
    }

    public void setGoodsAlias(String goodsAlias) {
        this.goodsAlias = goodsAlias;
    }

    public String getCateCode() {
        return cateCode;
    }

    public void setCateCode(String cateCode) {
        this.cateCode = cateCode;
    }

    public String getCateName() {
        return cateName;
    }

    public void setCateName(String cateName) {
        this.cateName = cateName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getGoodsMemo() {
        return goodsMemo;
    }

    public void setGoodsMemo(String goodsMemo) {
        this.goodsMemo = goodsMemo;
    }

    public String getGoodsDesc() {
        return goodsDesc;
    }

    public void setGoodsDesc(String goodsDesc) {
        this.goodsDesc = goodsDesc;
    }

    public BigDecimal getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(BigDecimal shelfLife) {
        this.shelfLife = shelfLife;
    }

    public String getShelfLiftUnit() {
        return shelfLiftUnit;
    }

    public void setShelfLiftUnit(String shelfLiftUnit) {
        this.shelfLiftUnit = shelfLiftUnit;
    }

    public Integer getCostValuationMethod() {
        return costValuationMethod;
    }

    public void setCostValuationMethod(Integer costValuationMethod) {
        this.costValuationMethod = costValuationMethod;
    }

    public Integer getIsBatchManagement() {
        return isBatchManagement;
    }

    public void setIsBatchManagement(Integer isBatchManagement) {
        this.isBatchManagement = isBatchManagement;
    }

    public Integer getIsSerialManagement() {
        return isSerialManagement;
    }

    public void setIsSerialManagement(Integer isSerialManagement) {
        this.isSerialManagement = isSerialManagement;
    }

    public Integer getIsPeriodManage() {
        return isPeriodManage;
    }

    public void setIsPeriodManage(Integer isPeriodManage) {
        this.isPeriodManage = isPeriodManage;
    }

    public Integer getGoodsAttr() {
        return goodsAttr;
    }

    public void setGoodsAttr(Integer goodsAttr) {
        this.goodsAttr = goodsAttr;
    }

    public Integer getIsProsaleProduct() {
        return isProsaleProduct;
    }

    public void setIsProsaleProduct(Integer isProsaleProduct) {
        this.isProsaleProduct = isProsaleProduct;
    }

    public Integer getIsProxySale() {
        return isProxySale;
    }

    public void setIsProxySale(Integer isProxySale) {
        this.isProxySale = isProxySale;
    }

    public Integer getIsCustomizProduction() {
        return isCustomizProduction;
    }

    public void setIsCustomizProduction(Integer isCustomizProduction) {
        this.isCustomizProduction = isCustomizProduction;
    }

    public Integer getIsDoorService() {
        return isDoorService;
    }

    public void setIsDoorService(Integer isDoorService) {
        this.isDoorService = isDoorService;
    }

    public Integer getIsPaidService() {
        return isPaidService;
    }

    public void setIsPaidService(Integer isPaidService) {
        this.isPaidService = isPaidService;
    }

    public Integer getIsPickupCard() {
        return isPickupCard;
    }

    public void setIsPickupCard(Integer isPickupCard) {
        this.isPickupCard = isPickupCard;
    }

    public Integer getIsProductionMaterials() {
        return isProductionMaterials;
    }

    public void setIsProductionMaterials(Integer isProductionMaterials) {
        this.isProductionMaterials = isProductionMaterials;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public List<SkuInfo> getSkuList() {
        return skuList;
    }

    public void setSkuList(List<SkuInfo> skuList) {
        this.skuList = skuList;
    }

    public List<PackageSku> getPackageSkuList() {
        return packageSkuList;
    }

    public void setPackageSkuList(List<PackageSku> packageSkuList) {
        this.packageSkuList = packageSkuList;
    }
}
