package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 库存调拨上传请求参数
 * API: /open/allocate/kc/upload
 */
@Data
public class AllocateUploadRequest {

    /**
     * 调拨单列表
     */
    private List<AllocateItem> list;

    @Data
    public static class AllocateItem {
        /**
         * 外部订单号（单据上传成功之后对应页面线上订单号）
         */
        private String so_id;

        /**
         * 单据日期
         */
        private String io_date;

        /**
         * 金额
         */
        private BigDecimal price;

        /**
         * 调出仓公司id
         */
        private Integer go_co_id;

        /**
         * 调出仓公司内仓库id
         * 主仓=1，销退仓=2，进货仓=3，次品仓=4，自定义1仓=6，自定义2仓=7，自定义3仓=8，
         * 自定义4仓=9，自定义5仓=10，自定义6仓=11，自定义7仓=12，自定义8仓=13，
         * 自定义9仓=14，自定义10仓=15
         */
        private Integer warehouse;

        /**
         * 调入仓公司id
         */
        private Integer link_co_id;

        /**
         * 调入仓公司内仓库id
         */
        private Integer link_warehouse;

        /**
         * 备注
         */
        private String remark;

        /**
         * 物流单号
         */
        private String l_id;

        /**
         * 物流公司编码
         */
        private String lc_id;

        /**
         * 商品列表
         */
        private List<AllocateItemDetail> items;

        /**
         * 收货人
         */
        private String receiver_name;

        /**
         * 移动电话
         */
        private String receiver_mobile;

        /**
         * 省
         */
        private String receiver_state;

        /**
         * 市
         */
        private String receiver_city;

        /**
         * 区
         */
        private String receiver_district;

        /**
         * 详细地址
         */
        private String receiver_address;

        /**
         * 是否自动完成单据
         */
        private Boolean is_confirm;

        /**
         * 是否自动确认单据（针对非销售占有库存的true为确认）
         */
        private Boolean is_confirming;

        /**
         * 标记｜多标签
         */
        private List<String> labels;

        /**
         * 调拨出运营云仓
         */
        private Integer lock_wh_id;

        /**
         * 调拨入运营云仓
         */
        private Integer link_lock_wh_id;
    }

    @Data
    public static class AllocateItemDetail {
        /**
         * 商品编码
         */
        private String sku_id;

        /**
         * 商品数量
         */
        private Integer qty;

        /**
         * 唯一码集合（开启唯一码及商品开启唯一码）
         */
        private List<String> sku_sns;

        /**
         * 批次号
         */
        private String batch_id;

        /**
         * 生产日期
         */
        private String produced_date;

        /**
         * 有效期
         */
        private String expiration_date;

        /**
         * 备注
         */
        private String remark;
    }
}