package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * ClassName: PurchaseInAllotQueryRequest
 * Description: 调拨查询请求参数
 *
 */
@Data
public class PurchaseInAllotQueryRequest {

    @ApiModelProperty("第几页，从1开始")
    private Integer page_index;

    @ApiModelProperty("默认30，最大不超过50")
    private Integer page_size;

    @ApiModelProperty("修改起始时间,起始时间和结束时间必须同时存在，时间间隔不能超过七天，与采购单号不能同时为空")
    private String modified_begin;

    @ApiModelProperty("修改结束时间,起始时间和结束时间必须同时存在，时间间隔不能超过七天，与采购单号不能同时为空")
    private String modified_end;

    @ApiModelProperty("采购单号与修改时间不能同时为空.采购单号最大不能超过30条")
    private List<Integer> po_ids;

    @ApiModelProperty("入库单号与修改时间不能同时为空.采购入库单号最大不能超过30条")
    private List<Integer> io_ids;

    @ApiModelProperty("单据状态;不填写默认查询已入库状态(WaitConfirm待入库;Confirmed已入库;Cancelled取消；Delete作废；Archive 归档；OuterConfirming 外部确认中)")
    private List<String> statuss;

    @ApiModelProperty("线上单号与修改时间不能同时为空")
    private List<String> so_ids;

    @ApiModelProperty("时间戳，sql server中的行版本号，该字段查询防止分页过程中漏单")
    private Integer start_ts;

    @ApiModelProperty("是否查询总条数默认true，如果使用start_ts查询，该值传false否则影响查询效率")
    private Boolean is_get_total;

    @ApiModelProperty("0:修改时间，modified。 2:入库时间 io_date，未传入时默认为0")
    private Integer date_type;


    @ApiModelProperty("货主编码（三方仓商家不传货主默认查自身数据，若查所有货主需传值：2147483647）")
    private Integer owner_co_id;


    @ApiModelProperty("调拨类型（调拨出，调拨入）")
    private Integer type;
}