package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 聚水潭出入库结果明细查询响应
 * API: jushuitan.inoutresult.inoutresultdetail.query
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InOutResultDetailQueryResponse extends JushuitanBaseResponse {

    /**
     * 第几页
     */
    private Integer page_index;

    /**
     * 每页多少条
     */
    private Integer page_size;

    /**
     * 总条数
     */
    private Integer data_count;

    /**
     * 总页数
     */
    private Integer page_count;

    /**
     * 是否有下一页
     */
    private Boolean has_next;

    /**
     * 数据列表
     */
    private List<InOutResultDetailData> data;

    /**
     * 调用链
     */
    private String traceid;

    /**
     * 异常信息
     */
    private String message;

    /**
     * 游标
     */
    private String cursor;

    /**
     * 是否成功
     */
    private Boolean issuccess;

    @Data
    public static class InOutResultDetailData {
        /**
         * 编号ID，数据唯一键
         */
        private Long id;

        /**
         * 业务主键（如果已结账，后续生成结账后变更，bc_no可能重复）
         */
        private String bc_no;

        /**
         * 单据号
         */
        private Long actual_id;

        /**
         * 子单据号
         */
        private Long actual_detail_id;

        /**
         * 会计区间
         */
        private String current_bill_period;

        /**
         * 单据时间
         */
        private String dw_fc_bill_date;

        /**
         * 创建时间
         */
        private String dw_created;

        /**
         * 更新时间
         */
        private String cdc_ts;

        /**
         * 单据来源:实际出入库，虚拟，核销，调整数量，调整发出余额
         */
        private String bill_type;

        /**
         * 单据类型：销售出仓、销售退货、销售退款、换货、无出入库单出库、无出入库单退货、无出入库单换货、无信息件、自动调整、手动调整、收款（仅到账版有）
         */
        private String bill_detail_type;

        /**
         * 单据属性： 正常单据：0； 历史单据：1；正常单据结账后变更单据：2 ； 历史单据结账后变更单据：3 ； 全部：null
         */
        private String bill_flag_nm;

        /**
         * 特殊标签
         */
        private String situation;

        /**
         * 结账状态： 已结账；未结账
         */
        private String is_settle_nm;

        /**
         * 出入库时间
         */
        private String io_date;

        /**
         * 出入库方向
         */
        private String io_type;

        /**
         * 出入库内部单号
         */
        private Long io_id;

        /**
         * 出入库内部子单号
         */
        private Long ioi_id;

        /**
         * 红蓝字
         */
        private Integer red_blue_flag;

        /**
         * 店铺编码
         */
        private Long shop_id;

        /**
         * 店铺名称
         */
        private String shop_name;

        /**
         * 分仓编码
         */
        private Long wms_co_id;

        /**
         * 分仓名称
         */
        private String wms_co_name;

        /**
         * 仓库编码
         */
        private Long wh_id;

        /**
         * 仓库名称
         */
        private String wh_name;

        /**
         * 供销商编码
         */
        private Long drp_co_id_to;

        /**
         * 供销商名称
         */
        private String drp_co_id_to_name;

        /**
         * 分销商编码
         */
        private Long drp_co_id_from;

        /**
         * 分销商名称
         */
        private String drp_co_id_from_name;

        /**
         * 出入库标签
         */
        private String inout_labels;

        /**
         * 是否扣库存。 对应ERP销售出库单的使用库存。 on是使用库存，off不使用库存。
         */
        private String inout_stock_enabled;

        /**
         * 出入库数量(实发)
         */
        private Integer sent_qty;

        /**
         * 批次对象
         */
        private List<BatchInfo> batchs;

        /**
         * 商品编码
         */
        private String sku_id;

        /**
         * 商品名称
         */
        private String sku_name;

        /**
         * 商品款号
         */
        private String i_id;

        /**
         * 商品品牌
         */
        private String brand;

        /**
         * 商品大类
         */
        private String category;

        /**
         * 商品属性
         */
        private String properties_value;

        /**
         * 虚拟分类
         */
        private String vc_name;

        /**
         * 颜色规格
         */
        private String color;

        /**
         * 是否赠品:是;否
         */
        private String is_gift_str;

        /**
         * 内部单号
         */
        private Long o_id;

        /**
         * 内部子单号（订单明细行）
         */
        private Long oi_id;

        /**
         * 线上单号
         */
        private String so_id;

        /**
         * 原始线上单号
         */
        private String item_so_id;

        /**
         * 原始线上子单号
         */
        private String outer_oi_id;

        /**
         * 实收/实退金额
         */
        private BigDecimal bc_amount;

        /**
         * 其中运费收入
         */
        private BigDecimal freight;

        /**
         * 商家优惠
         */
        private BigDecimal free_amount;

        /**
         * 商品金额
         */
        private BigDecimal amount;

        /**
         * 发货时间
         */
        private String send_date;

        /**
         * 订单标签
         */
        private String order_labels;

        /**
         * 订单类型
         */
        private String order_type;

        /**
         * 成本单价
         */
        private BigDecimal cost_price;

        /**
         * 成本金额
         */
        private BigDecimal cost_amount;

        /**
         * 订单/售后商品数量
         */
        private Integer order_qty;

        /**
         * 快递单号
         */
        private String l_id;

        /**
         * 快递公司编码
         */
        private String lc_id;

        /**
         * 业务员编号
         */
        private Long order_creator;

        /**
         * 业务员
         */
        private String creator_name;

        /**
         * 币种
         */
        private String currency;

        /**
         * 兑人民币汇率(原币)
         */
        private BigDecimal currency_to_rmb;

        /**
         * 订单明细总数
         */
        private Integer oid_count;

        /**
         * 售后单号
         */
        private Long as_id;

        /**
         * 售后单子单号
         */
        private Long asi_id;

        /**
         * 售后类型
         */
        private String aftersale_type;

        /**
         * 售后确认时间
         */
        private String aftersale_confirm_date;

        /**
         * 售后标签
         */
        private String aftersale_labels;

        /**
         * 售后问题类型
         */
        private String aftersale_question_type;

        /**
         * 商品数量
         */
        private Integer dw_fc_goods_qty;

        /**
         * 销售收入
         */
        private BigDecimal dw_fc_sales_income;

        /**
         * 收入调整项
         */
        private BigDecimal income_ajustment_amount;

        /**
         * 销售成本
         */
        private BigDecimal dw_fc_sales_cost;

        /**
         * 应收账款
         */
        private BigDecimal dw_fc_paid_amount;

        /**
         * 资产减值损失
         */
        private BigDecimal dw_fc_amount_loss;

        /**
         * 发出商品
         */
        private BigDecimal dw_fc_sent_goods_amount;

        /**
         * 库存商品
         */
        private BigDecimal dw_fc_stock_goods_amount;

        /**
         * 发出商品数量
         */
        private Integer dw_fc_sent_goods_qty;

        /**
         * 库存商品数量
         */
        private Integer dw_fc_stock_goods_qty;

        /**
         * 未处理
         */
        private BigDecimal dw_fc_nodeal_amount;

        /**
         * 核销用商品数量
         */
        private Integer dw_check_goods_qty;

        /**
         * 核销用库存商品数量
         */
        private Integer dw_check_stock_goods_qty;

        /**
         * 核销用应收账款
         */
        private BigDecimal dw_check_paid_amount;

        /**
         * 到账金额=平台补贴到账+买家实付到账 注意：当存在手工核销时，单据的账单金额=到账金额+调整金额
         */
        private BigDecimal bc_result_amount;

        /**
         * 平台补贴到账
         */
        private BigDecimal platform_subsidy;

        /**
         * 买家实付到账
         */
        private BigDecimal buyer_pay_amount;

        /**
         * 到账时间
         */
        private String bc_date;

        /**
         * 核销系统时间
         */
        private String bc_operate_date;

        /**
         * 核销单号
         */
        private String check_no;

        /**
         * 核销方式： 自动核销（有账单）； 手工核销（有账单）； 手工调整（无账单）；
         */
        private String check_way;

        /**
         * 操作用户（手动核销、手动调整等的操作账号）
         */
        private String check_user;

        /**
         * 用户选择的金额分摊方式（系统分摊：Auto手工输入User
         */
        private String check_amount_split_type;

        /**
         * 调整金额（客户手工核销时产生的调整差额）=平台补贴调整+买家实付调整
         */
        private BigDecimal bc_adjustment_amount;

        /**
         * 平台补贴调整
         */
        private BigDecimal adjustment_platform_subsidy;

        /**
         * 买家实付调整
         */
        private BigDecimal adjustment_buyer_pay_amount;

        /**
         * 核销备注（用户输入的备注）
         */
        private String bc_remark;

        /**
         * 数量核销系统时间
         */
        private String qty_check_operate_date;

        /**
         * 数量核销时间
         */
        private String qty_check_date;

        /**
         * 数量核销方式： 自动核销; 手动核销; 未核销
         */
        private String qty_check_way;

        /**
         * 数量核销单号
         */
        private String qty_check_no;

        /**
         * 发出商品核销系统时间
         */
        private String sentgoods_check_operate_date;

        /**
         * 发出商品核销时间
         */
        private String sentgoods_check_date;

        /**
         * 发出商品核销方式：自动核销; 手动核销; 未核销
         */
        private String sentgoods_check_way;

        /**
         * 发出商品核销单号
         */
        private String sentgoods_check_no;

        /**
         * 仅退款调整结果：用户在仅退款追踪表调整反写的标签；涉及：仅退款、待退货、快递赔付、用户自定义标签等；
         */
        private String onlyrefund_approve_result;

        /**
         * 仅退款调整时间：用户在仅退款追踪表调整时反写的时间
         */
        private String onlyrefund_approve_date;

        /**
         * 组合装商品编码
         */
        private String combine_sku_id;

        /**
         * 买家账号
         */
        private String shop_buyer_id_en;

        /**
         * 金额核销记账时间
         */
        private String amountcheck_accounting_date;

        /**
         * 唯一码集合(仅当商家erp基础设置开启了商品唯一码才可获取)
         */
        private List<SnInfo> sns;

        /**
         * 卖家备注
         */
        private String order_remark;

        /**
         * 虚拟仓ID
         */
        private String bu_id;

        /**
         * 销售出仓出入库子单号
         */
        private Long out_ioi_id;

        /**
         * 枚举值：未妥投，已妥投
         */
        private String delivered_status;

        /**
         * 妥投记账时间(仅妥投版有该字段)：妥投时间和生成妥投原单单据时间的较大值。
         */
        private String delivered_accounting_time;

        /**
         * 妥投时间(仅妥投版有该字段)
         */
        private String delivered_time;
    }

    @Data
    public static class BatchInfo {
        /**
         * 批次号
         */
        private String batch_no;
        
        /**
         * 有效期/过期日期
         */
        private String expire_date;
        
        /**
         * 生产日期
         */
        private String produce_date;
        
        /**
         * 批次数量
         */
        private Integer qty;
        
        /**
         * 批次备注
         */
        private String remark;
    }

    @Data
    public static class SnInfo {
        /**
         * 唯一码
         */
        private String sn;
    }
}