package com.elitesland.zhiyuan.openapi.outer.nc.service;

import com.elitesland.zhiyuan.openapi.outer.nc.dto.NcRequestDTO;
import com.elitesland.zhiyuan.openapi.outer.nc.dto.NcResponseDTO;

public interface NcService {

    String test();

    /**
     * 用forest调用nc api
     *
     * @param request 请求
     * @return {@link NcResponseDTO }
     */
    NcResponseDTO callNcApiWithForest(NcRequestDTO request);

    /**
     * 用forest调用nc api
     *
     * @param request             请求
     * @param pushRecordInterType 推送记录类型
     * @param docId               文档Id
     * @param docNo               文件编号
     * @return {@link NcResponseDTO }
     */
    NcResponseDTO callNcApiWithForest(NcRequestDTO request, String pushRecordInterType, Long docId, String docNo);

    /**
     * 获取令牌
     *
     * @param secret   秘密
     * @param userCode  用户代码
     * @param timestamp 时间戳
     * @return {@link String }
     */
    String getToken(String secret, String userCode, String timestamp);

}
