package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin;



import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
/**
 * @description: 创建入库申请单并入库请求参数
 * luoxin
 */
@Data
public class ErpStockCreateAndStockInRequestBizData extends BaseRequestBizData {
	/**
	 * 供应商编码 
	 */ 
	private String vendCode;
	/**
	 * 部门编号和公司编号 要同时填否则部门信息会有偏差 
	 */ 
	private String applyDepartCode;
	/**
	 * 公司编号和部门编号 要同时填否则公司信息会有偏差 
	 */ 
	private String applyCompanyCode;
	/**
	 * 仓库code 
	 */ 
	private String inWarehouseCode;
	/**
	 * 入库类型 101=采购入库 102=调拨入库 103=盘盈入库 104=其他入库 
	 */ 
	private Integer inType;
	/**
	 * 关联单据编号 
	 */ 
	private String relDataId;
	/**
	 * 申请人id 
	 */ 
	private String applyUserId;
	/**
	 * 申请人 
	 */ 
	private String applyUserName;
	/**
	 * 申请部门 
	 */ 
	private String applyDepartName;
	/**
	 * 申请时间 
	 */ 
	private Date applyDate;
	/**
	 * 备注 
	 */ 
	private String memo;
	/**
	 * 审核人 
	 */ 
	private String auditUserName;
	/**
	 * 审核时间 
	 */ 
	private Date auditDate;
	/**
	 * 传固定值100 
	 */ 
	private String notificationCode;
	/**
	 * 制单人 
	 */ 
	private String operator;
	/**
	 * 写死：OPEN 
	 */ 
	private String source;
	/**
	 * 币种 
	 */ 
	private String currencyCode;
	/**
	 * 汇率 
	 */ 
	private BigDecimal currencyRate;
	/**
	 * 标记 
	 */ 
	private String flagData;
	/**
	 * 预计入库时间 
	 */ 
	private Date planInDate;
	/**
	 * 物流公司名称 
	 */ 
	private String logisticName;
	/**
	 * 物流类型 
	 */ 
	private String logisticType;
	/**
	 * 物流单号 
	 */ 
	private String logisticNo;
	/**
	 * 物流公司编号 
	 */ 
	private String logisticCode;
	/**
	 * 入库申请单明细 
	 */ 
	private List<StockInDetailViews> stockInDetailViews;
	/**
	 * 发件公司名称 
	 */ 
	private String sendCompanyName;
	/**
	 * 发件人 
	 */ 
	private String send;
	/**
	 * 发件人电话 
	 */ 
	private String sendTel;
	/**
	 * 发件人手机号 
	 */ 
	private String sendPhone;
	/**
	 * 发件人邮箱 
	 */ 
	private String sendEmail;
	/**
	 * 发件人国家id 
	 */ 
	private Integer sendCountryId;
	/**
	 * 发件人国家 
	 */ 
	private String sendCountryName;
	/**
	 * 发件人省id 
	 */ 
	private Integer sendProvinceId;
	/**
	 * 发件人省 
	 */ 
	private String sendProvinceName;
	/**
	 * 发件人市id 
	 */ 
	private Integer sendCityId;
	/**
	 * 发件人市 
	 */ 
	private String sendCityName;
	/**
	 * 发件人区id 
	 */ 
	private Integer sendTownId;
	/**
	 * 发件人镇，区 
	 */ 
	private String sendTownName;
	/**
	 * 发件人街道id 
	 */ 
	private Integer sendStreetId;
	/**
	 * 发件人街道 
	 */ 
	private String sendStreetName;
	/**
	 * 发件人详细地址 
	 */ 
	private String sendAddress;
	/**
	 * 收件公司名称 
	 */ 
	private String receiveCompanyName;
	/**
	 * 收件人 
	 */ 
	private String receive;
	/**
	 * 收件人电话 
	 */ 
	private String receiveTel;
	/**
	 * 收件人手机号 
	 */ 
	private String receivePhone;
	/**
	 * 收件人邮箱 
	 */ 
	private String receiveEmail;
	/**
	 * 收件人国家id 
	 */ 
	private Integer receiveCountryId;
	/**
	 * 收件人国家 
	 */ 
	private String receiveCountryName;
	/**
	 * 收件人省id 
	 */ 
	private Integer receiveProvinceId;
	/**
	 * 收件人省 
	 */ 
	private String receiveProvinceName;
	/**
	 * 收件人市id 
	 */ 
	private Integer receiveCityId;
	/**
	 * 收件人市 
	 */ 
	private String receiveCityName;
	/**
	 * 收件人区id 
	 */ 
	private Integer receiveTownId;
	/**
	 * 收件人镇，区 
	 */ 
	private String receiveTownName;
	/**
	 * 收件人街道id 
	 */ 
	private Integer receiveStreetId;
	/**
	 * 收件人街道 
	 */ 
	private String receiveStreetName;
	/**
	 * 收件人详细地址 
	 */ 
	private String receiveAddress;
	/**
	 * 是否自动解析地址(当省市区为空时,自动解析详情地址的省市区) 
	 */ 
	private Integer isAutoResolutionAddress;
	/**
	 * 当收发件人信息为空,自动取仓库的收发件人信息 
	 */ 
	private Integer isSetFromWarehouse;
	/**
	 * 批次受仓库批次开关控制，若仓库不开启批次，则忽略传入的批次信息 （1 = 控制 ，0 或者 不传 =不控制 ） 
	 */ 
	private Byte batchControlByWarehouse;

}

