/*
 * Copyright(C) 2018 Hangzhou DifferSoft Co., Ltd. All rights reserved.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.data;

import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * API调用返回结果。
 *
 luoxin
 */
public class JackyunResponse {

    /**
     * 构造器。
     *
     * @param subCode 子级错误码
     * @param msg     错误消息
     */
    public JackyunResponse(Object result, String subCode, String msg, String contextId) {
        Map<String, Object> map = new HashMap<>();
        map.put("data", result);
        map.put("contextId", contextId);
        this.result = map;
        this.subCode = subCode;
        this.msg = msg;
    }

    /**
     * 构造器。
     *
     * @param subCode 子级错误码
     * @param msg     错误消息
     */
    public JackyunResponse(Object result, String subCode, String msg) {
        this(result,subCode,msg,null);
    }

    /**
     * 构造器。
     *
     * @param subCode 子级错误码
     * @param msg     错误消息
     */
    public JackyunResponse(String subCode, String msg) {
        this(null,subCode,msg,null);
    }

    public JackyunResponse() {
    }

    /**
     * 返回码
     */
    private String code;

    /**
     * 子级错误码
     */
    private String subCode;

    /**
     * 错误消息
     */
    private String msg;

    /**
     * 错误结果
     */
    private Object result;

    /**
     * 获取 core
     *
     * @return core
     */
    public String getCode() {
        return code;
    }

    /**
     * 设置 core
     *
     * @param code 要设置的 core
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取 msg
     *
     * @return msg
     */
    public String getMsg() {
        return msg;
    }

    /**
     * 设置 msg
     *
     * @param msg 要设置的 msg
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 获取 result
     *
     * @return result
     */
    public Object getResult() {
        return result;
    }

    /**
     * 设置 result
     *
     * @param result 要设置的 result
     */
    public void setResult(Object result) {
        this.result = result;
    }

    /**
     * 转换为json字符串。
     *
     * @return
     */
    public String toJson() {
        return JsonUtils.toJson(this);
    }
    /**
     * 当请求失败。
     *
     * @param msg     返回消息
     * @param subCode 子级返回码
     */
    public void onFail(String msg, String subCode){
        this.code = "0";
        this.msg = msg;
        this.subCode = subCode;
    }

    /**
     * 当请求成功。
     *
     */
    public void onSuccess(){
        this.code = "200";
    }

    /**
     * 是否成功
     *@return 是否成功
     */
    public boolean isSuccess() {
        return "200".equalsIgnoreCase(this.code);
    }
}
