/*
 * Copyright(C) 2017 Hangzhou Differsoft Co., Ltd. All rights reserved.
 */

package com.elitesland.zhiyuan.openapi.outer.jackyun.service;


import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunMemberInfo;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 请求吉客云开放平台服务。
 *
 * @author luoxin
 */
@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JackyunOpenClientService {

    private final OutsidePushRecordRepository outsidePushRecordRepository;

    /**
     * 请求开放平台服务。
     *
     * @param method  开放接口方法名
     * @param bizData 请求业务数据
     * @return OpenResponse返回对象
     */
    public JackyunResponse callApi(String method, BaseRequestBizData bizData, String pushRecordInterType, Long docId, String docNo) {
        //接口返回值
        JackyunResponse response = null;

        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody(JsonUtils.toJson(bizData));
        //返回值字符串
        String strResponse = "";
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizData), memberInfo);
            response = JsonUtils.deJson(strResponse, JackyunResponse.class);
            if (response.isSuccess()) {
                pushRecordDTO.setReqSuccess(true);
            } else {
                pushRecordDTO.setReqSuccess(false);
            }
            pushRecordDTO.setRespBody(response);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        } catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            pushRecordDTO.setErrorMsg(ex.getMessage());
            pushRecordDTO.setReqSuccess(false);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;
        }
        return response;
    }

    /**
     * 请求开放平台服务。
     *
     * @param method  开放接口方法名
     * @param bizData 请求业务数据
     * @return OpenResponse返回对象
     */
    public JackyunResponse call(String method, BaseRequestBizData bizData) {
        //接口返回值
        JackyunResponse response = null;
        //返回值字符串
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizData), memberInfo);
        } catch (Exception ex) {
            response = new com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse.class);
    }

    /**
     * 请求开放平台服务。
     *
     * @param method      开放接口方法名
     * @param bizDataList 请求业务数据 数组
     * @return OpenResponse返回对象
     */
    public JackyunResponse callBatch(String method, List<BaseRequestBizData> bizDataList) {
        //接口返回值
        JackyunResponse response = null;
        //返回值字符串
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();

        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizDataList), memberInfo);
        } catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, JackyunResponse.class);
    }

    /**
     * 请求开放平台服务。
     *
     * @param method      开放接口方法名
     * @param bizDataList 请求业务数据 数组
     * @return OpenResponse返回对象
     */
    public JackyunResponse callBatchApi(String method, List<BaseRequestBizData> bizDataList, String pushRecordInterType, Long docId, String docNo) {
        //接口返回值
        JackyunResponse response = null;
        //返回值字符串
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody(JsonUtils.toJson(bizDataList));
        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizDataList), memberInfo);
            response = JsonUtils.deJson(strResponse, JackyunResponse.class);
            if (response.isSuccess()) {
                pushRecordDTO.setReqSuccess(true);
            } else {
                pushRecordDTO.setReqSuccess(false);
            }
            pushRecordDTO.setRespBody(response);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        } catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            pushRecordDTO.setErrorMsg(ex.getMessage());
            pushRecordDTO.setReqSuccess(false);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;
        }
        return response;
    }
}
