package com.elitesland.zhiyuan.openapi.outer.jushuitan.exception;

/**
 * NC接口异常
 *
 * @author generated
 */
public class JstApiException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final Integer code;
    private final String msg;
    private final String msgType;
    private final String requestId;

    public JstApiException(String message) {
        super(message);
        this.code = null;
        this.msg = null;
        this.msgType = null;
        this.requestId = null;
    }

    public JstApiException(String message, Throwable cause) {
        super(message, cause);
        this.code = null;
        this.msg = null;
        this.msgType = null;
        this.requestId = null;
    }

    // response.getCode(), response.getMsg(), response.getMsg_type(), response.getRequest_id())
    public JstApiException(Integer code, String msg, String msgType, String requestId) {
                super(String.format("YST接口调用失败 - 响应编码:%s, 响应消息:%s, 消息类型:%s, 请求ID:%s",
                           code, msg, msgType, requestId));
        this.code = code;
        this.msg = msg;
        this.msgType = msgType;
        this.requestId = msgType;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getMsgType() {
        return msgType;
    }

    public String getRequestId() {
        return requestId;
    }
}