package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * ClassName: WarehouseQueryResponse
 * Description: 仓库查询响应参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class WarehouseQueryResponse extends JushuitanBaseResponse<WarehouseQueryResponse.WarehouseQueryData> {

    /**
     * 仓库查询响应数据
     */
    @Data
    public static class WarehouseQueryData {

        @ApiModelProperty("仓库数据列表")
        private List<WarehouseData> datas;

        @ApiModelProperty("总条数")
        private Integer data_count;

        @ApiModelProperty("总页数")
        private Integer page_count;

        @ApiModelProperty("是否有下一页")
        private Boolean has_next;

        @ApiModelProperty("第几页")
        private Integer page_index;

        @ApiModelProperty("每页多少条")
        private Integer page_size;
    }

    /**
     * 仓库数据
     */
    @Data
    public static class WarehouseData {

        @ApiModelProperty("分仓名称")
        private String name;

        @ApiModelProperty("主仓公司编号")
        private Integer co_id;

        @ApiModelProperty("分仓编号")
        private Integer wms_co_id;

        @ApiModelProperty("是否为主仓，true=主仓")
        private Boolean is_main;

        @ApiModelProperty("状态")
        private String status;

        @ApiModelProperty("对方备注")
        private String remark1;

        @ApiModelProperty("我方备注")
        private String remark2;
    }
}