/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.client;

import com.elitesland.zhiyuan.openapi.outer.jackyun.config.GikyCloudConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.stereotype.Component;

@Component
public class GikyCloudClient {
    private final GikyCloudConfig config;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String BIZCONTENT = "bizcontent";
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public GikyCloudClient(GikyCloudConfig config) {
        this.config = config;
    }

    public String post(String method, String version, String token, Object bizData) throws Exception {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put("method", method);
        sortedMap.put("appkey", this.config.getAppkey());
        sortedMap.put("version", version != null ? version : this.config.getVersion());
        sortedMap.put("contenttype", "json");
        sortedMap.put("timestamp", DEFAULT_DATETIME_FORMATTER.format(LocalDateTime.now()));
        sortedMap.put(BIZCONTENT, this.objectMapper.writeValueAsString(bizData));
        String sign = this.generateSignature(sortedMap);
        sortedMap.put("sign", sign);
        if (token != null && !token.isEmpty()) {
            sortedMap.put("token", token);
        }
        StringBuilder postData = new StringBuilder();
        for (Map.Entry entry : sortedMap.entrySet()) {
            if (postData.length() > 0) {
                postData.append("&");
            }
            if (BIZCONTENT.equalsIgnoreCase((String)entry.getKey())) {
                postData.append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.name()));
                continue;
            }
            postData.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return this.postData(this.config.getGateway(), postData.toString());
    }

    private String generateSignature(SortedMap<String, String> params) throws Exception {
        StringBuilder sb = new StringBuilder(this.config.getAppsecret());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(entry.getKey()).append(entry.getValue());
        }
        sb.append(this.config.getAppsecret());
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(sb.toString().toLowerCase().getBytes(StandardCharsets.UTF_8));
        return this.bytesToHex(digest);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private String postData(String urlStr, String postData) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        conn.getOutputStream().write(postData.getBytes(StandardCharsets.UTF_8));
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("HTTP error code: " + responseCode + ", message: " + conn.getResponseMessage());
        }
        try {
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                string = reader.lines().reduce("", String::concat);
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }
}

