package com.elitesland.zhiyuan.openapi.outer.jackyun.service;

import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpallocateQuery.ErpStockAllocateQueryRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpallocatecreate.ErpStockAllocateRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout.ErpStockCreateAndStockOutRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget.ErpStockInGetRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2.ErpStorageGoodsDocInV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;

public interface JackyunService {

    /**
     * 创建物料接口
     */
    JackyunResponse createMaterial(MaterialCreateRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 创建供应商
     * @param request
     * @return
     */
    JackyunResponse createVendor(VendCreateRequest request,String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 采购入库创建
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockCreateAndStockIn(ErpStockCreateAndStockInRequestBizData requestBizData, Long docId, String docNo);
    /**
     * 采购入库查询
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockInGet(ErpStockInGetRequestBizData requestBizData, Long docId, String docNo);
    /**
     * 采购出库创建
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockCreateAndStockOut(ErpStockCreateAndStockOutRequestBizData requestBizData, Long docId, String docNo);
    /**
     * 采购出库查询
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStorageGoodsDocOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, Long docId, String docNo);


    /**
     * 吉客云入库单查询
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStorageGoodsDocInV2(ErpStorageGoodsDocInV2RequestBizData requestBizData, Long docId, String docNo);

    /**
     * 吉客云调拨单创建
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockAllocateCreate(ErpStockAllocateRequestBizData requestBizData, Long docId, String docNo);
    /**
     * 吉客云调拨单查询
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockAllocateQuery(ErpStockAllocateQueryRequestBizData requestBizData, Long docId, String docNo);


    /**
     * 采购出库创建
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStockFailAndStockOut(ErpStockCreateAndStockOutRequestBizData requestBizData, Long docId, String docNo);
    /**
     * 采购出库查询
     * @param requestBizData
     * @param docId
     * @param docNo
     * @return
     */
    JackyunResponse erpStorageGoodsDocFailOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, Long docId, String docNo);


}