package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * ClassName: PurchaseInboundQueryResponse
 * Description: 采购入库查询响应参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PurchaseInboundQueryResponse extends JushuitanBaseResponse<PurchaseInboundQueryResponse.PurchaseInboundQueryData> {

    /**
     * 采购入库查询响应数据
     */
    @Data
    public static class PurchaseInboundQueryData {

        @ApiModelProperty("采购入库数据列表")
        private List<PurchaseInboundData> datas;

        @ApiModelProperty("第几页")
        private Integer page_index;

        @ApiModelProperty("是否有下一页")
        private Boolean has_next;

        @ApiModelProperty("总条数")
        private Integer data_count;

        @ApiModelProperty("总页数")
        private Integer page_count;

        @ApiModelProperty("每页多少条")
        private Integer page_size;
    }

    /**
     * 采购入库数据
     */
    @Data
    public static class PurchaseInboundData {

        @ApiModelProperty("采购单号")
        private Integer po_id;

        @ApiModelProperty("入库日期")
        private String io_date;

        @ApiModelProperty("备注")
        private String remark;

        @ApiModelProperty("仓库名称")
        private String warehouse;

        @ApiModelProperty("进仓类型")
        private String type;

        @ApiModelProperty("税率")
        private BigDecimal tax_rate;

        @ApiModelProperty("入库单号")
        private Integer io_id;

        @ApiModelProperty("标签")
        private String labels;

        @ApiModelProperty("财务审核日期")
        private String archived;

        @ApiModelProperty("预约单号")
        private String merge_so_id;

        @ApiModelProperty("分仓编号")
        private Integer wms_co_id;

        @ApiModelProperty("仓库编号")
        private String wh_id;

        @ApiModelProperty("线上单号")
        private String so_id;

        @ApiModelProperty("修改时间")
        private String modified;

        @ApiModelProperty("制单人")
        private String creator_name;

        @ApiModelProperty("供应商名称")
        private String supplier_name;

        @ApiModelProperty("供应商编号")
        private Integer supplier_id;

        @ApiModelProperty("财审状态")
        private String f_status;

        @ApiModelProperty("状态")
        private String status;

        @ApiModelProperty("外部单号")
        private String out_io_id;

        @ApiModelProperty("数据库行版本号")
        private String ts;

        @ApiModelProperty("虚拟仓编码")
        private Integer lock_wh_id;

        @ApiModelProperty("备注2")
        private String extend_remark;

        @ApiModelProperty("物流单号")
        private String l_id;

        @ApiModelProperty("物流公司")
        private String logistics_company;

        @ApiModelProperty("商品明细信息")
        private List<PurchaseInboundItem> items;

        @ApiModelProperty("唯一码集合")
        private List<SnData> sns;

        @ApiModelProperty("生产批次集合")
        private List<BatchData> batchs;
    }

    /**
     * 商品明细信息
     */
    @Data
    public static class PurchaseInboundItem {

        @ApiModelProperty("入库子单号")
        private Integer ioi_id;

        @ApiModelProperty("商品编码")
        private String sku_id;

        @ApiModelProperty("款式编码")
        private String i_id;

        @ApiModelProperty("单位")
        private String unit;

        @ApiModelProperty("商品名称")
        private String name;

        @ApiModelProperty("入库数量")
        private Integer qty;

        @ApiModelProperty("入库单号")
        private Integer io_id;

        @ApiModelProperty("单价")
        private BigDecimal cost_price;

        @ApiModelProperty("金额")
        private BigDecimal cost_amount;

        @ApiModelProperty("商品明细备注")
        private String remark;

        @ApiModelProperty("批次号")
        private String batch_no;

        @ApiModelProperty("税率")
        private Integer tax_rate;
    }

    /**
     * 唯一码数据
     */
    @Data
    public static class SnData {

        @ApiModelProperty("商品编码")
        private String sku_id;

        @ApiModelProperty("唯一码")
        private String sn;
    }

    /**
     * 生产批次数据
     */
    @Data
    public static class BatchData {

        @ApiModelProperty("批次号")
        private String batch_no;

        @ApiModelProperty("商品编码")
        private String sku_id;

        @ApiModelProperty("商品名称")
        private String name;

        @ApiModelProperty("数量")
        private Integer qty;

        @ApiModelProperty("批次日期")
        private String product_date;

        @ApiModelProperty("供应商编号")
        private Integer supplier_id;

        @ApiModelProperty("供应商名称")
        private String supplier_name;

        @ApiModelProperty("有效期至")
        private String expiration_date;

        @ApiModelProperty("子单号")
        private String ioi_id;

        @ApiModelProperty("款式编码")
        private String i_id;
    }
}