/*
 * smart-doc https://github.com/shalousun/smart-doc
 *
 * Copyright (C) 2018-2022 smart-doc
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.smartdoc.gradle.chain;


import com.smartdoc.gradle.model.CustomArtifact;

/**
 * @author yu 2020/1/13.
 */
public class CommonArtifactFilterChain implements FilterChain {

    private FilterChain filterChain;

    @Override
    public void setNext(FilterChain nextInChain) {
        this.filterChain = nextInChain;
    }

    @Override
    public boolean ignoreArtifactById(CustomArtifact artifact) {
        String artifactId = artifact.getArtifactId();
        switch (artifactId) {
            case "aspectjweaver":
            case "fastjson":
            case "bcprov-jdk15on":
            case "bcpkix-jdk15on":
            case "lombok":
            case "jsqlparser":
            case "disruptor":
            case "snakeyaml":
            case "spring-boot-autoconfigure":
            case "HikariCP":
            case "mysql-connector-java":
            case "classmate":
            case "commons-codec":
            case "commons-lang3":
            case "commons-text":
            case "commons-beanutils":
            case "commons-beanutils-core":
            case "spring-web":
            case "spring-webmvc":
            case "hibernate-validator":
            case "hibernate-core":
            case "xstream":
            case "guava":
            case "spring-tx":
            case "javassist":
            case "javafaker":
            case "qdox":
            case "gson":
            case "netty-all":
            case "javacv-platform":
            case "antlr4-runtime":
            case "jetty":
            case "velocity":
            case "beetl":
            case "xml-apis":
            case "mchange-commons-java":
            case "hadoop-common":
            case "txw2":
            case "jakarta.xml.bind-api":
            case "smart-doc-gradle-plugin":
            case "druid":
            case "mssql-jdbc":
                return true;
            default:
                return this.ignore(filterChain, artifact);
        }
    }
}
