/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.gradle.task;

import com.power.common.util.RegexUtil;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.model.ApiConfig;
import com.smartdoc.gradle.extension.SmartDocPluginExtension;
import com.smartdoc.gradle.model.CustomArtifact;
import com.smartdoc.gradle.util.ArtifactFilterUtil;
import com.smartdoc.gradle.util.GradleUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedArtifactResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;

public abstract class DocBaseTask
extends DefaultTask {
    protected JavaProjectBuilder javaProjectBuilder;
    private static String MSG = "The loaded local code path is ";

    public abstract void executeAction(ApiConfig var1, JavaProjectBuilder var2, Logger var3);

    @TaskAction
    public void action() {
        Path path;
        Path rpcConsumerPath;
        ApiConfig apiConfig;
        Logger logger = this.getLogger();
        Project project = this.getProject();
        logger.quiet("Smart-doc Starting Create API Documentation.");
        SmartDocPluginExtension pluginExtension = (SmartDocPluginExtension)project.getExtensions().getByType(SmartDocPluginExtension.class);
        Set<String> excludes = pluginExtension.getExclude();
        Set<String> includes = pluginExtension.getInclude();
        this.javaProjectBuilder = this.buildJavaProjectBuilder(project, excludes, includes);
        this.javaProjectBuilder.setEncoding("utf-8");
        File file = pluginExtension.getConfigFile();
        if (Objects.isNull(file)) {
            file = new File("./src/main/resources/default.json");
        }
        if ((apiConfig = GradleUtil.buildConfig(file, project, logger)) == null) {
            logger.quiet("Failed to build ApiConfig, check if the configuration file is correct.");
            return;
        }
        if (Objects.nonNull(apiConfig.getRpcConsumerConfig()) && !(rpcConsumerPath = Paths.get(apiConfig.getRpcConsumerConfig(), new String[0])).isAbsolute()) {
            apiConfig.setRpcConsumerConfig(project.getProjectDir().getPath() + "/" + apiConfig.getRpcConsumerConfig());
        }
        if (!(path = Paths.get(apiConfig.getOutPath(), new String[0])).isAbsolute()) {
            apiConfig.setOutPath(project.getProjectDir().getPath() + "/" + apiConfig.getOutPath());
        }
        logger.quiet("API Documentation output to " + apiConfig.getOutPath());
        this.executeAction(apiConfig, this.javaProjectBuilder, logger);
    }

    private JavaProjectBuilder buildJavaProjectBuilder(Project project, Set<String> excludes, Set<String> includes) {
        JavaProjectBuilder javaDocBuilder = new JavaProjectBuilder();
        javaDocBuilder.setEncoding("utf-8");
        javaDocBuilder.setErrorHandler(e -> this.getLogger().warn(e.getMessage()));
        String projectDir = project.getProjectDir().getPath();
        String projectCodePath = String.join((CharSequence)DocGlobalConstants.FILE_SEPARATOR, projectDir, DocGlobalConstants.PROJECT_CODE_PATH);
        this.getLogger().quiet(MSG + projectCodePath);
        javaDocBuilder.addSourceTree(new File(projectCodePath));
        this.loadSourcesDependencies(javaDocBuilder, project, excludes, includes);
        return javaDocBuilder;
    }

    private void loadSourcesDependencies(JavaProjectBuilder javaDocBuilder, Project project, Set<String> excludes, Set<String> includes) {
        Configuration compileConfiguration = project.getConfigurations().getByName("compileClasspath");
        ArrayList<ComponentIdentifier> binaryDependencies = new ArrayList<ComponentIdentifier>();
        TreeMap<String, Project> allModules = this.getAllModule(project.getRootProject());
        Set resolvedArtifacts = compileConfiguration.getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact resolvedArtifact : resolvedArtifacts) {
            CustomArtifact artifact;
            String artifactName;
            String displayName = resolvedArtifact.getId().getComponentIdentifier().getDisplayName();
            CustomArtifact moduleArtifact = null;
            boolean selfModule = displayName.startsWith("project :");
            if (selfModule) {
                ResolvedModuleVersion version = resolvedArtifact.getModuleVersion();
                moduleArtifact = CustomArtifact.builder().setGroup(version.getId().getGroup()).setArtifactId(version.getId().getName()).setVersion(version.getId().getVersion());
                artifactName = moduleArtifact.getGroup() + ":" + moduleArtifact.getArtifactId();
                this.addModuleSourceTree(javaDocBuilder, allModules, artifactName);
            }
            if (ArtifactFilterUtil.ignoreArtifact(artifact = selfModule ? moduleArtifact : CustomArtifact.builder(displayName)) || ArtifactFilterUtil.ignoreSpringBootArtifactById(artifact) || RegexUtil.isMatches(excludes, (String)(artifactName = artifact.getGroup() + ":" + artifact.getArtifactId()))) continue;
            if (RegexUtil.isMatches(includes, (String)artifactName)) {
                if (selfModule) {
                    this.addModuleSourceTree(javaDocBuilder, allModules, displayName);
                    continue;
                }
                binaryDependencies.add(resolvedArtifact.getId().getComponentIdentifier());
                continue;
            }
            if (includes.size() >= 1 || selfModule) continue;
            binaryDependencies.add(resolvedArtifact.getId().getComponentIdentifier());
        }
        Set artifactsResults = project.getDependencies().createArtifactResolutionQuery().forComponents(binaryDependencies).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class}).execute().getResolvedComponents();
        for (ComponentArtifactsResult artifactResult : artifactsResults) {
            for (ArtifactResult sourcesResult : artifactResult.getArtifacts(SourcesArtifact.class)) {
                if (!(sourcesResult instanceof DefaultResolvedArtifactResult)) continue;
                this.loadSourcesDependency(javaDocBuilder, (DefaultResolvedArtifactResult)sourcesResult);
            }
        }
    }

    private void loadSourcesDependency(JavaProjectBuilder javaDocBuilder, DefaultResolvedArtifactResult artifact) {
        try (JarFile jarFile = new JarFile(artifact.getFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".java") || name.endsWith("/package-info.java")) continue;
                javaDocBuilder.addSource(new URL("jar:" + artifact.getFile().toURI().toURL().toString() + "!/" + name));
            }
        }
        catch (Throwable e) {
            this.getLogger().warn("Unable to load jar source " + artifact + " : " + e.getMessage());
        }
    }

    private void addModuleSourceTree(JavaProjectBuilder javaDocBuilder, TreeMap<String, Project> allModules, String artifactName) {
        Project module = allModules.getOrDefault(artifactName, null);
        if (module != null) {
            String modelSrc = String.join((CharSequence)File.separator, module.getProjectDir().getAbsolutePath(), "src/main/java");
            this.getLogger().quiet(MSG + modelSrc);
            javaDocBuilder.addSourceTree(new File(modelSrc));
        }
    }

    private TreeMap<String, Project> getAllModule(Project rootProject) {
        TreeMap<String, Project> result = new TreeMap<String, Project>();
        if (Objects.isNull(rootProject)) {
            return result;
        }
        if (rootProject.getDepth() != 0) {
            result.put(rootProject.getGroup() + ":" + rootProject.getName(), rootProject);
        }
        if (rootProject.getChildProjects().isEmpty()) {
            return result;
        }
        rootProject.getChildProjects().forEach((k, v) -> result.putAll(this.getAllModule((Project)v)));
        return result;
    }
}

