/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.gradle.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.BodyAdvice;
import com.smartdoc.gradle.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class GradleUtil {
    public static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }).create();

    public static ApiConfig buildConfig(File configFile, Project project, Logger log) {
        try {
            ClassLoader classLoader = ClassLoaderUtil.getRuntimeClassLoader(project);
            String data = FileUtil.getFileContent((InputStream)new FileInputStream(configFile));
            ApiConfig apiConfig = (ApiConfig)GSON.fromJson(data, ApiConfig.class);
            List apiDataDictionaries = apiConfig.getDataDictionaries();
            List apiErrorCodes = apiConfig.getErrorCodeDictionaries();
            List apiConstants = apiConfig.getApiConstants();
            BodyAdvice responseBodyAdvice = apiConfig.getResponseBodyAdvice();
            BodyAdvice requestBodyAdvice = apiConfig.getRequestBodyAdvice();
            if (Objects.nonNull(apiErrorCodes)) {
                apiErrorCodes.forEach(apiErrorCode -> {
                    String className = apiErrorCode.getEnumClassName();
                    apiErrorCode.setEnumClass(GradleUtil.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(apiDataDictionaries)) {
                apiDataDictionaries.forEach(apiDataDictionary -> {
                    String className = apiDataDictionary.getEnumClassName();
                    apiDataDictionary.setEnumClass(GradleUtil.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(apiConstants)) {
                apiConstants.forEach(apiConstant -> {
                    String className = apiConstant.getConstantsClassName();
                    apiConstant.setConstantsClass(GradleUtil.getClassByClassName(className, classLoader));
                });
            }
            if (Objects.nonNull(responseBodyAdvice) && StringUtil.isNotEmpty((String)responseBodyAdvice.getClassName())) {
                responseBodyAdvice.setWrapperClass(GradleUtil.getClassByClassName(responseBodyAdvice.getClassName(), classLoader));
            }
            if (Objects.nonNull(requestBodyAdvice) && StringUtil.isNotEmpty((String)requestBodyAdvice.getClassName())) {
                requestBodyAdvice.setWrapperClass(GradleUtil.getClassByClassName(requestBodyAdvice.getClassName(), classLoader));
            }
            if (StringUtil.isEmpty((String)apiConfig.getProjectName())) {
                apiConfig.setProjectName(project.getName());
            }
            GradleUtil.addSourcePaths(project, apiConfig, log);
            return apiConfig;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassByClassName(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addSourcePaths(Project project, ApiConfig apiConfig, Logger log) {
    }
}

