/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import java.text.SimpleDateFormat;
import java.util.Date;

public class InterfaceLogBean {
    private static final String DATE_FMT_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    private String transactionId;
    private String product;
    private String interfaceType;
    private String protocolType;
    private String name;
    private String sourceAddr;
    private String targetAddr;
    private Date reqTime;
    private String reqTimeAsString;
    private Date respTime;
    private String respTimeAsString;
    private String reqParams;
    private String resultCode;
    private String respParams;

    public InterfaceLogBean() {
    }

    public InterfaceLogBean(String name, String targetAddr, String reqParams) {
        this.transactionId = "";
        this.interfaceType = "1";
        this.product = "Storage";
        this.protocolType = "HTTP+XML";
        this.reqTime = new Date();
        this.name = name;
        this.sourceAddr = "";
        this.targetAddr = "";
        this.reqParams = reqParams;
    }

    public void setResponseInfo(String respParams, String resultCode) {
        this.respParams = respParams;
        this.resultCode = resultCode;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public String getTargetAddr() {
        return this.targetAddr;
    }

    public void setTargetAddr(String targetAddr) {
        this.targetAddr = targetAddr;
    }

    public Date getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(Date reqTime) {
        this.reqTime = reqTime;
    }

    public String getReqTimeAsString() {
        if (null == this.reqTimeAsString && null != this.reqTime) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FMT_YYYYMMDDHHMMSS);
            return df.format(this.reqTime);
        }
        return this.reqTimeAsString;
    }

    public void setReqTimeAsString(String reqTimeAsString) {
        this.reqTimeAsString = reqTimeAsString;
    }

    public Date getRespTime() {
        return this.respTime;
    }

    public void setRespTime(Date respTime) {
        this.respTime = respTime;
    }

    public String getRespTimeAsString() {
        if (null == this.respTimeAsString && null != this.respTime) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FMT_YYYYMMDDHHMMSS);
            return df.format(this.respTime);
        }
        return this.respTimeAsString;
    }

    public void setRespTimeAsString(String respTimeAsString) {
        this.respTimeAsString = respTimeAsString;
    }

    public String getReqParams() {
        return this.reqParams;
    }

    public void setReqParams(String reqParams) {
        this.reqParams = reqParams;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getRespParams() {
        return this.respParams;
    }

    public void setRespParams(String respParams) {
        this.respParams = respParams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProduct()).append("|");
        sb.append(this.getInterfaceType()).append("|");
        sb.append(this.getProtocolType()).append("|");
        sb.append(this.getName()).append("|");
        sb.append(this.getSourceAddr()).append("|");
        sb.append(this.getTargetAddr()).append("|");
        sb.append(this.getTransactionId() == null ? "" : this.getTransactionId()).append("|");
        sb.append(this.getReqTimeAsString()).append("|");
        sb.append(this.getRespTimeAsString()).append("|");
        sb.append(this.getReqParams() == null ? "" : this.getReqParams()).append("|");
        sb.append(this.getRespParams() == null ? "" : this.getRespParams()).append("|");
        sb.append(this.getResultCode()).append("|");
        return sb.toString();
    }
}

