/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.task.AbstractObsTask;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreObjectTask
extends AbstractObsTask {
    private RestoreObjectRequest taskRequest;
    protected TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback;

    public RestoreObjectTask(ObsClient obsClient, String bucketName) {
        super(obsClient, bucketName);
    }

    public RestoreObjectTask(ObsClient obsClient, String bucketName, RestoreObjectRequest taskRequest, TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback) {
        super(obsClient, bucketName);
        this.taskRequest = taskRequest;
        this.callback = callback;
    }

    public RestoreObjectTask(ObsClient obsClient, String bucketName, RestoreObjectRequest taskRequest, TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback, TaskProgressListener listener, DefaultTaskProgressStatus progressStatus, int taskProgressInterval) {
        super(obsClient, bucketName, progressStatus, listener, taskProgressInterval);
        this.taskRequest = taskRequest;
        this.callback = callback;
    }

    public RestoreObjectRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setTaskRequest(RestoreObjectRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    public TaskCallback<RestoreObjectResult, RestoreObjectRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback) {
        this.callback = callback;
    }

    private void restoreObjects() {
        try {
            RestoreObjectResult result = this.obsClient.restoreObjectV2(this.taskRequest);
            this.progressStatus.succeedTaskIncrement();
            this.callback.onSuccess(result);
        }
        catch (ObsException e) {
            this.progressStatus.failTaskIncrement();
            this.callback.onException(e, this.taskRequest);
        }
        this.progressStatus.execTaskIncrement();
        if (this.progressListener != null) {
            if (this.progressStatus.getExecTaskNum() % this.taskProgressInterval == 0) {
                this.progressListener.progressChanged(this.progressStatus);
            }
            if (this.progressStatus.getExecTaskNum() == this.progressStatus.getTotalTaskNum()) {
                this.progressListener.progressChanged(this.progressStatus);
            }
        }
    }

    @Override
    public void run() {
        this.restoreObjects();
    }
}

