/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.task.UploadTaskProgressStatus;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.UploadObjectsProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumableUploadTask
implements Runnable {
    protected ObsClient obsClient;
    protected String bucketName;
    private UploadObjectsProgressListener progressListener;
    private int taskProgressInterval;
    private UploadFileRequest taskRequest;
    private TaskCallback<PutObjectResult, PutObjectBasicRequest> callback;
    private UploadTaskProgressStatus taskStatus;

    public ResumableUploadTask(ObsClient obsClient, String bucketName, UploadFileRequest taskRequest, TaskCallback<PutObjectResult, PutObjectBasicRequest> callback, UploadObjectsProgressListener progressListener, UploadTaskProgressStatus progressStatus, int taskProgressInterval) {
        this.obsClient = obsClient;
        this.bucketName = bucketName;
        this.taskRequest = taskRequest;
        this.callback = callback;
        this.progressListener = progressListener;
        this.taskStatus = progressStatus;
        this.taskProgressInterval = taskProgressInterval;
    }

    public ObsClient getObsClient() {
        return this.obsClient;
    }

    public void setObsClient(ObsClient obsClient) {
        this.obsClient = obsClient;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public UploadObjectsProgressListener getUploadObjectsProgressListener() {
        return this.progressListener;
    }

    public void setUploadObjectsProgressListener(UploadObjectsProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public int getTaskProgressInterval() {
        return this.taskProgressInterval;
    }

    public void setTaskProgressInterval(int taskProgressInterval) {
        this.taskProgressInterval = taskProgressInterval;
    }

    public UploadFileRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setTaskRequest(UploadFileRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    public TaskCallback<PutObjectResult, PutObjectBasicRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<PutObjectResult, PutObjectBasicRequest> callback) {
        this.callback = callback;
    }

    public UploadTaskProgressStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(UploadTaskProgressStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ResumableUpload() {
        String key2222;
        ProgressStatus status2222;
        block15: {
            try {
                try {
                    CompleteMultipartUploadResult result = this.obsClient.uploadFile(this.taskRequest);
                    this.taskStatus.succeedTaskIncrement();
                    PutObjectResult ret = new PutObjectResult(result.getBucketName(), result.getObjectKey(), result.getEtag(), result.getVersionId(), result.getObjectUrl(), result.getResponseHeaders(), result.getStatusCode());
                    this.callback.onSuccess(ret);
                }
                catch (ObsException e) {
                    String key2222;
                    ProgressStatus status2222;
                    this.taskStatus.failTaskIncrement();
                    this.callback.onException(e, this.taskRequest);
                    Object var4_5 = null;
                    this.taskStatus.execTaskIncrement();
                    if (this.progressListener != null) {
                        if (this.taskStatus.getExecTaskNum() % this.taskProgressInterval == 0) {
                            this.progressListener.progressChanged(this.taskStatus);
                        }
                        if (this.taskStatus.getExecTaskNum() == this.taskStatus.getTotalTaskNum()) {
                            this.progressListener.progressChanged(this.taskStatus);
                        }
                    }
                    if ((status2222 = this.taskStatus.getTaskStatus(key2222 = this.taskRequest.getObjectKey())) != null) {
                        this.taskStatus.addEndingTaskSize(status2222.getTransferredBytes());
                    }
                    this.taskStatus.removeTaskTable(key2222);
                    return;
                }
                Object var4_4 = null;
                this.taskStatus.execTaskIncrement();
                if (this.progressListener == null) break block15;
                if (this.taskStatus.getExecTaskNum() % this.taskProgressInterval == 0) {
                    this.progressListener.progressChanged(this.taskStatus);
                }
                if (this.taskStatus.getExecTaskNum() != this.taskStatus.getTotalTaskNum()) break block15;
                this.progressListener.progressChanged(this.taskStatus);
            }
            catch (Throwable throwable) {
                String key2222;
                ProgressStatus status2222;
                Object var4_6 = null;
                this.taskStatus.execTaskIncrement();
                if (this.progressListener != null) {
                    if (this.taskStatus.getExecTaskNum() % this.taskProgressInterval == 0) {
                        this.progressListener.progressChanged(this.taskStatus);
                    }
                    if (this.taskStatus.getExecTaskNum() == this.taskStatus.getTotalTaskNum()) {
                        this.progressListener.progressChanged(this.taskStatus);
                    }
                }
                if ((status2222 = this.taskStatus.getTaskStatus(key2222 = this.taskRequest.getObjectKey())) != null) {
                    this.taskStatus.addEndingTaskSize(status2222.getTransferredBytes());
                }
                this.taskStatus.removeTaskTable(key2222);
                throw throwable;
            }
        }
        if ((status2222 = this.taskStatus.getTaskStatus(key2222 = this.taskRequest.getObjectKey())) != null) {
            this.taskStatus.addEndingTaskSize(status2222.getTransferredBytes());
        }
        this.taskStatus.removeTaskTable(key2222);
    }

    @Override
    public void run() {
        this.ResumableUpload();
    }
}

