/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tsf.femas.extension.springcloud.instrumentation.zuul;

import com.netflix.zuul.context.RequestContext;
import com.tencent.tsf.femas.common.context.Context;
import com.tencent.tsf.femas.common.context.ContextConstant;
import com.tencent.tsf.femas.common.context.factory.ContextFactory;
import com.tencent.tsf.femas.common.header.AbstractRequestMetaUtils;
import com.tencent.tsf.femas.governance.lane.LaneService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuultHeaderUtils
extends AbstractRequestMetaUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZuultHeaderUtils.class);
    private volatile ContextConstant contextConstant = ContextFactory.getContextConstantInstance();
    private static final String UNKNOWN = "unknown";
    private RequestContext requestContext;
    private volatile Context commonContext = ContextFactory.getContextInstance();

    public ZuultHeaderUtils(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void preprocess() {
    }

    public void setRequestMeta(String name, String value) {
        LaneService.headerPreprocess();
        for (Map.Entry entry : this.commonContext.getRequestMetaSerializeTags().entrySet()) {
            if (!com.tencent.tsf.femas.common.util.StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            try {
                this.requestContext.addZuulRequestHeader((String)entry.getKey(), URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("[UnsupportedEncodingException] name:{}, value:{}", entry.getKey(), entry.getValue());
                this.requestContext.addZuulRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getRequestMeta(String name) {
        String value = (String)this.requestContext.getZuulRequestHeaders().get(name);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("[UnsupportedEncodingException] getHeader, name:{}, value:{}", (Object)name, (Object)value);
            }
        }
        return value;
    }

    public Map<String, String> getPrefixRequestMetas(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map headersMap = this.requestContext.getZuulRequestHeaders();
        for (Map.Entry entry : headersMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    public void getUniqueInfo() {
        if (StringUtils.isEmpty((CharSequence)Context.getRpcInfo().get("source.connection.ip"))) {
            Context.getRpcInfo().put("source.connection.ip", ZuultHeaderUtils.getIpAddr(this.requestContext.getRequest()));
        }
        Context.getRpcInfo().put(this.contextConstant.getInterface(), this.requestContext.getRequest().getRequestURI());
        Context.getRpcInfo().put(this.contextConstant.getRequestHttpMethod(), this.requestContext.getRequest().getMethod());
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            logger.error("IPUtils ERROR ", (Throwable)e);
        }
        return ip;
    }
}

