/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tsf.femas.extension.zuul.filter;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.tencent.tsf.femas.api.ExtensionManager;
import com.tencent.tsf.femas.api.IExtensionLayer;
import com.tencent.tsf.femas.common.context.Context;
import com.tencent.tsf.femas.common.context.ContextConstant;
import com.tencent.tsf.femas.common.context.RpcContext;
import com.tencent.tsf.femas.common.context.TracingContext;
import com.tencent.tsf.femas.common.context.factory.ContextFactory;
import com.tencent.tsf.femas.common.entity.ErrorStatus;
import com.tencent.tsf.femas.common.entity.Request;
import com.tencent.tsf.femas.common.entity.Response;
import com.tencent.tsf.femas.common.entity.Service;
import com.tencent.tsf.femas.common.entity.ServiceInstance;
import com.tencent.tsf.femas.common.header.AbstractRequestMetaUtils;
import com.tencent.tsf.femas.extension.springcloud.instrumentation.zuul.ZuultHeaderUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonRoutingFilter;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class FemasRibbonRoutingFilter
extends RibbonRoutingFilter {
    private static final Log log = LogFactory.getLog(FemasRibbonRoutingFilter.class);
    private volatile ContextConstant contextConstant = ContextFactory.getContextConstantInstance();
    private String namespace = Context.getSystemTag((String)this.contextConstant.getNamespaceId());
    private IExtensionLayer extensionLayer = ExtensionManager.getExtensionLayer();

    public FemasRibbonRoutingFilter(ProxyRequestHelper helper, RibbonCommandFactory<?> ribbonCommandFactory, List<RibbonRequestCustomizer> requestCustomizers) {
        super(helper, ribbonCommandFactory, requestCustomizers);
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        this.helper.addIgnoredHeaders(new String[0]);
        HttpServletRequest httpServletRequest = context.getRequest();
        URL url = this.getUrl(httpServletRequest);
        Request femasRequest = Context.getRpcInfo().getRequest();
        if (femasRequest == null) {
            femasRequest = this.getFemasRequest(context);
        }
        String httpMethod = httpServletRequest.getMethod();
        femasRequest.setInterfaceName(url.getPath());
        femasRequest.setTargetMethodSig(httpMethod + "/" + context.get((Object)"requestURI"));
        femasRequest.setDoneChooseInstance(false);
        RpcContext rpcContext = this.extensionLayer.beforeClientInvoke(femasRequest, (AbstractRequestMetaUtils)new ZuultHeaderUtils(context));
        RibbonCommandContext commandContext = this.buildCommandContext(context);
        ClientHttpResponse response = null;
        Throwable error = null;
        try {
            if (rpcContext.getErrorStatus() != null && ErrorStatus.Code.CIRCUIT_BREAKER.equals((Object)rpcContext.getErrorStatus().getCode())) {
                String errorMsg = "CircuitBreaker Error. IsolationLevel : " + rpcContext.getErrorStatus().getMessage() + ", Request : " + femasRequest;
                throw new ZuulRuntimeException(new ZuulException(errorMsg, 500, errorMsg));
            }
            response = this.forward(commandContext);
            this.setResponse(response);
        }
        catch (ZuulRuntimeException e) {
            error = e;
            throw e;
        }
        catch (Exception e) {
            error = e;
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ZuulRuntimeException(new ZuulException(e.getCause(), 500, e.getMessage()));
        }
        finally {
            try {
                Response femasResponse = new Response();
                if (error != null) {
                    femasResponse.setError(error);
                    femasResponse.setErrorStatus(ErrorStatus.INTERNAL);
                } else if (response.getRawStatusCode() >= 400) {
                    femasResponse.setErrorStatus(ErrorStatus.INTERNAL);
                    femasResponse.setError((Throwable)new RuntimeException(String.valueOf(response.getRawStatusCode())));
                }
                this.fillTracingContext(rpcContext, httpServletRequest, response, femasRequest, url);
                this.extensionLayer.afterClientInvoke(femasRequest, femasResponse, rpcContext);
                Context.getRpcInfo().setRequest(null);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    private URL getUrl(HttpServletRequest request) {
        URL url = null;
        try {
            url = new URL(new String(request.getRequestURL()));
        }
        catch (MalformedURLException e) {
            log.warn((Object)("MalformedURLException, feign request:" + request), (Throwable)e);
        }
        return url;
    }

    private Request getFemasRequest(RequestContext requestContext) {
        Request request = new Request();
        String[] uriArr = requestContext.get((Object)"serviceId").toString().split("/");
        String serviceName = uriArr.length < 2 ? uriArr[0] : uriArr[1];
        Service service = new Service();
        service.setName(serviceName);
        service.setNamespace(this.namespace);
        request.setTargetService(service);
        Context.getRpcInfo().setRequest(request);
        return request;
    }

    private void fillTracingContext(RpcContext rpcContext, HttpServletRequest request, ClientHttpResponse response, Request femasRequest, URL url) throws IOException {
        Service targetService;
        ServiceInstance serviceInstance;
        TracingContext tracingContext = rpcContext.getTracingContext();
        tracingContext.setProtocol("http");
        tracingContext.setLocalServiceName(Context.getSystemTag((String)this.contextConstant.getServiceName()));
        tracingContext.setLocalNamespaceId(Context.getSystemTag((String)this.contextConstant.getNamespaceId()));
        tracingContext.setLocalInstanceId(Context.getSystemTag((String)this.contextConstant.getInstanceId()));
        tracingContext.setLocalApplicationVersion(Context.getSystemTag((String)this.contextConstant.getApplicationVersion()));
        tracingContext.setLocalHttpMethod(Context.getRpcInfo().get(this.contextConstant.getRequestHttpMethod()));
        tracingContext.setLocalInterface(Context.getRpcInfo().get(this.contextConstant.getInterface()));
        tracingContext.setLocalIpv4(Context.getSystemTag((String)this.contextConstant.getLocalIp()));
        String localPort = Context.getSystemTag((String)this.contextConstant.getLocalPort());
        if (StringUtils.isNotEmpty((CharSequence)localPort)) {
            tracingContext.setLocalPort(Integer.valueOf(localPort));
        }
        tracingContext.setRemoteHttpMethod(request.getMethod());
        if (url != null) {
            tracingContext.setRemoteInterface(url.getPath());
            tracingContext.setRemoteIpv4(url.getHost());
            tracingContext.setRemotePort(Integer.valueOf(url.getPort()));
        }
        if ((serviceInstance = femasRequest.getTargetServiceInstance()) != null && serviceInstance.getAllMetadata() != null) {
            tracingContext.setRemoteApplicationVersion(serviceInstance.getMetadata(this.contextConstant.getMetaApplicationVersionKey()));
            tracingContext.setRemoteInstanceId(serviceInstance.getMetadata(this.contextConstant.getMetaInstanceIdKey()));
        }
        if ((targetService = femasRequest.getTargetService()) != null) {
            tracingContext.setRemoteServiceName(targetService.getName());
            tracingContext.setRemoteNamespaceId(targetService.getNamespace());
        }
        if (response != null) {
            tracingContext.setResultStatus(String.valueOf(response.getRawStatusCode()));
        }
        Context.getRpcInfo().put(this.contextConstant.getInterface(), null);
        Context.getRpcInfo().put(this.contextConstant.getRequestHttpMethod(), null);
    }
}

