/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.channels;

import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.LogUtilities;
import com.vertica.support.channels.AbstractSocketChannel;
import com.vertica.support.channels.ISocketChannelReadCallback;
import com.vertica.support.channels.SocketChannelMessageKey;
import com.vertica.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class PlainSocketChannel
extends AbstractSocketChannel {
    protected static final int READ_BUFFER_CAPACITY = 512000;
    private ByteBuffer m_readBuffer = ByteBuffer.allocateDirect(512000);

    public PlainSocketChannel(SocketChannel internal, ISocketChannelReadCallback readCallback, ILogger logger) throws ErrorException {
        super(internal, readCallback, logger);
        this.m_readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean write(ByteBuffer writeBuffer) throws ErrorException {
        return this.write(new ByteBuffer[]{writeBuffer}, 0, 1);
    }

    @Override
    public boolean write(ByteBuffer[] writeBuffers, int offset, int length) throws ErrorException {
        if (null == this.m_internal || this.isClosed()) {
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        }
        long bytesWritten = 0L;
        while (this.arrayHasRemaining(writeBuffers, offset, length)) {
            try {
                bytesWritten = this.m_internal.write(writeBuffers, offset, length);
                if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                    LogUtilities.logTrace(String.format("%d bytes written to channel %s", bytesWritten, this.getChannelID()), this.m_log);
                }
                if (0L != bytesWritten) continue;
                return true;
            }
            catch (IOException ex) {
                String message;
                if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                    LogUtilities.logDebug(String.format("Error occurred while writing on channel %s: %s", this.getChannelID(), ex), this.m_log);
                }
                if (null != (message = ex.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), message, (Throwable)ex);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public void read() throws ErrorException {
        int bytesRead = -2;
        do {
            try {
                bytesRead = this.m_internal.read(this.m_readBuffer);
            }
            catch (IOException ex) {
                String message;
                if (LogUtilities.shouldLogLevel(LogLevel.FATAL, this.m_log)) {
                    LogUtilities.logFatal(String.format("Error occurred while reading on channel %s: %s", this.getChannelID(), ex), this.m_log);
                }
                if (null != (message = ex.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), message, (Throwable)ex);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), (Throwable)ex);
            }
            if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                LogUtilities.logTrace(String.format("%d bytes read from channel %s", bytesRead, this.getChannelID()), this.m_log);
            }
            if (-1 != bytesRead) continue;
            this.readCallback(this.m_readBuffer);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        } while (bytesRead > 0);
        this.readCallback(this.m_readBuffer);
    }

    @Override
    public int getReadBufferCapacity() {
        return 512000;
    }
}

