/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import java.util.Set;

public class WikiLinkLinkResolver
implements LinkResolver {
    private static String fromChars = " +/<>";
    private static String toChars = "-----";
    private final WikiLinkOptions options;

    public WikiLinkLinkResolver(LinkResolverContext context) {
        this.options = new WikiLinkOptions(context.getOptions());
    }

    public ResolvedLink resolveLink(Node node, LinkResolverContext context, ResolvedLink link) {
        if (link.getLinkType() == WikiLinkExtension.WIKI_LINK) {
            StringBuilder sb = new StringBuilder();
            boolean isWikiImage = node instanceof WikiImage;
            String wikiLink = link.getUrl();
            int iMax = wikiLink.length();
            sb.append(isWikiImage ? this.options.imagePrefix : this.options.linkPrefix);
            boolean hadAnchorRef = false;
            for (int i = 0; i < iMax; ++i) {
                int pos;
                char c = wikiLink.charAt(i);
                if (c == '#') {
                    if (hadAnchorRef) continue;
                    sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
                    hadAnchorRef = true;
                }
                if ((pos = fromChars.indexOf(c)) < 0) {
                    sb.append(c);
                    continue;
                }
                sb.append(toChars.charAt(pos));
            }
            if (!hadAnchorRef) {
                sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
            }
            if (isWikiImage) {
                return new ResolvedLink(LinkType.IMAGE, (CharSequence)sb.toString(), null, LinkStatus.UNCHECKED);
            }
            return new ResolvedLink(LinkType.LINK, (CharSequence)sb.toString(), null, LinkStatus.UNCHECKED);
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        public Set<Class<? extends LinkResolverFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends LinkResolverFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public LinkResolver create(LinkResolverContext context) {
            return new WikiLinkLinkResolver(context);
        }
    }
}

