/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.auth.credentials.provider.YopBaseCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class YopFixedCredentialsProvider
extends YopBaseCredentialsProvider {
    private final Map<String, YopAppConfig> appConfigs = Maps.newConcurrentMap();
    private final Map<String, YopCredentials> yopCredentialsMap = Maps.newConcurrentMap();

    public final YopCredentials<?> getCredentials(String provider, String env, String appKey, String credentialType) {
        String key = StringUtils.defaultString((String)provider, (String)"") + ":" + StringUtils.defaultString((String)env, (String)"") + ":" + appKey + ":" + credentialType;
        return this.yopCredentialsMap.computeIfAbsent(key, k -> this.buildCredentials(this.getAppConfig(provider, env, appKey), credentialType));
    }

    public List<CertTypeEnum> getSupportCertTypes(String appKey) {
        return this.getSupportCertTypes("", "", appKey);
    }

    public List<CertTypeEnum> getSupportCertTypes(String provider, String env, String appKey) {
        return Lists.newArrayList(this.getAppConfig(provider, env, appKey).getIsvPrivateKeys().keySet());
    }

    private YopAppConfig getAppConfig(String provider, String env, String appKey) {
        String theProvider = StringUtils.defaultString((String)provider, (String)"");
        String theEnv = StringUtils.defaultString((String)env, (String)"");
        String theAppKey = this.useDefaultIfBlank(theProvider, theEnv, appKey);
        return this.appConfigs.computeIfAbsent(theAppKey, k -> this.loadAppConfig(theProvider, theEnv, theAppKey));
    }

    protected abstract YopAppConfig loadAppConfig(String var1);

    protected YopAppConfig loadAppConfig(String provider, String env, String appKey) {
        return this.loadAppConfig(appKey);
    }

    public List<YopCertConfig> getIsvEncryptKey(String appKey) {
        return this.getIsvEncryptKey("", "", appKey);
    }

    public List<YopCertConfig> getIsvEncryptKey(String provider, String env, String appKey) {
        return this.getAppConfig(provider, env, appKey).getIsvEncryptKey();
    }
}

