/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.config.provider.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.base.config.provider.YopFixedSdkConfigProvider;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.BeanUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class YopFileSdkConfigProvider
extends YopFixedSdkConfigProvider {
    private static final YopFileSdkConfigProvider INSTANCE = new YopFileSdkConfigProvider();
    private static final Logger LOGGER = LoggerFactory.getLogger(YopFileSdkConfigProvider.class);
    public static final String SDK_CONFIG_ENV_PROPERTY_KEY = "yop.sdk.config.env";
    public static final String SDK_CONFIG_DIR_PROPERTY_KEY = "yop.sdk.config.dir";
    public static final String SDK_CONFIG_FILE_PROPERTY_KEY = "yop.sdk.config.file";
    private static final String SDK_CONFIG_DIR = "config";
    private static final String DEFAULT_CONFIG_FILE_NAME = "yop_sdk_config_default.json";
    private static final String DEFAULT_CONFIG_FILE = "config/yop_sdk_config_default.json";
    private Map<String, YopFileSdkConfig> sdkConfigs = Maps.newConcurrentMap();

    @Override
    protected YopSdkConfig loadSdkConfig() {
        return this.convertYopSdkConfig(this.loadSdkConfig(""));
    }

    @Override
    protected YopSdkConfig loadSdkConfig(String provider, String env) {
        return this.convertYopSdkConfig(this.loadSdkConfig(provider, env, ""));
    }

    public YopFileSdkConfig loadSdkConfig(String appKey) {
        return this.loadSdkConfig("", "", appKey);
    }

    public YopFileSdkConfig loadSdkConfig(String provider, String env, String appKey) {
        String theProvider = StringUtils.defaultString((String)provider, (String)"");
        String theEnv = StringUtils.defaultString((String)env, (String)"");
        String theAppKey = (String)StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)"default");
        String configKey = theProvider + "#" + theEnv + "#" + theAppKey;
        return this.sdkConfigs.computeIfAbsent(configKey, k -> this.doLoadYopFileSdkConfig(theProvider, theEnv, theAppKey));
    }

    private YopFileSdkConfig doLoadYopFileSdkConfig(String provider, String currentEnv, String appKey) {
        String providerConfigDefaultFile;
        String configDir = System.getProperty(SDK_CONFIG_DIR_PROPERTY_KEY);
        if (StringUtils.isNotEmpty((CharSequence)configDir)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.dir\uff0c\u503c\u4e3a\uff1a{}", (Object)configDir);
        } else {
            configDir = SDK_CONFIG_DIR;
        }
        if (StringUtils.isNotBlank((CharSequence)provider)) {
            configDir = configDir + "/" + provider;
            this.logger.info("\u6307\u5b9a\u4e86provider\uff0c\u503c\u4e3a\uff1a{}", (Object)provider);
        }
        String env = System.getProperty(SDK_CONFIG_ENV_PROPERTY_KEY, "");
        if (StringUtils.isNotBlank((CharSequence)currentEnv)) {
            this.logger.info("\u6307\u5b9a\u4e86env\uff0c\u503c\u4e3a\uff1a{}, \u7cfb\u7edfenv\uff1a{}", (Object)currentEnv, (Object)env);
            env = currentEnv;
            configDir = configDir + "/" + currentEnv;
        } else if (StringUtils.isNotBlank((CharSequence)env)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.env\uff0c\u503c\u4e3a\uff1a{}", (Object)env);
            configDir = configDir + "/" + env;
        }
        String configFile = "";
        String file = System.getProperty(SDK_CONFIG_FILE_PROPERTY_KEY);
        if (StringUtils.isNotEmpty((CharSequence)file)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.file\uff0c\u503c\u4e3a\uff1a{}", (Object)file);
            configFile = !StringUtils.startsWithAny((CharSequence)file, (CharSequence[])new CharSequence[]{"file://"}) ? configDir + "/" + file : file;
        } else {
            configFile = configDir + "/yop_sdk_config_" + appKey + ".json";
        }
        this.logger.info("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6{}", (Object)configFile);
        YopFileSdkConfig customSdkConfig = this.loadSdkConfigFile(configFile);
        HashSet loadedFiles = Sets.newHashSet((Object[])new String[]{configFile});
        String envConfigDefaultFile = this.getEnvConfigDefaultFile(provider, env);
        if (!loadedFiles.contains(envConfigDefaultFile)) {
            YopFileSdkConfig envDefaultConfig = this.loadSdkConfigFile(envConfigDefaultFile);
            customSdkConfig = this.fillNullConfig(envDefaultConfig, customSdkConfig);
        }
        if (!loadedFiles.contains(providerConfigDefaultFile = this.getProviderConfigDefaultFile(provider))) {
            YopFileSdkConfig providerDefaultConfig = this.loadSdkConfigFile(providerConfigDefaultFile);
            customSdkConfig = this.fillNullConfig(providerDefaultConfig, customSdkConfig);
        }
        String globalConfigDefaultFile = DEFAULT_CONFIG_FILE;
        if (!loadedFiles.contains(DEFAULT_CONFIG_FILE)) {
            YopFileSdkConfig globalDefaultConfig = this.loadSdkConfigFile(DEFAULT_CONFIG_FILE);
            customSdkConfig = this.fillNullConfig(globalDefaultConfig, customSdkConfig);
        }
        if (null == customSdkConfig) {
            throw new YopClientException("ConfigProblem, Can't load config, file:" + configFile);
        }
        return customSdkConfig;
    }

    private String getEnvConfigDefaultFile(String provider, String env) {
        return "config/" + (StringUtils.isNotBlank((CharSequence)provider) ? provider + "/" : "") + (StringUtils.isNotBlank((CharSequence)env) ? env + "/" : "") + DEFAULT_CONFIG_FILE_NAME;
    }

    private String getProviderConfigDefaultFile(String provider) {
        return "config/" + (StringUtils.isNotBlank((CharSequence)provider) ? provider + "/" : "") + DEFAULT_CONFIG_FILE_NAME;
    }

    private YopFileSdkConfig fillNullConfig(YopFileSdkConfig sourceBean, YopFileSdkConfig targetBean) {
        if (null == sourceBean) {
            return targetBean;
        }
        if (null == targetBean) {
            return sourceBean;
        }
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = targetBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field targetField;
            Field sourceField = sourceFields[i];
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic((targetField = targetFields[i]).getModifiers())) continue;
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (sourceField.get(sourceBean) == null || "serialVersionUID".equals(sourceField.getName()) || targetField.get(targetBean) != null) continue;
                targetField.set(targetBean, sourceField.get(sourceBean));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("error when fillNullConfig, ex:", (Throwable)e);
            }
        }
        return targetBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YopFileSdkConfig loadSdkConfigFile(String configFile) {
        YopFileSdkConfig sdkConfig = null;
        try {
            if (!StringUtils.startsWithAny((CharSequence)configFile, (CharSequence[])new CharSequence[]{"file://"})) {
                configFile = "classpath*:" + configFile;
            }
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(configFile);
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                StringBuilder script = new StringBuilder();
                BufferedReader bufferReader = null;
                try {
                    String tempString;
                    bufferReader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                    while ((tempString = bufferReader.readLine()) != null) {
                        script.append(tempString).append("\n");
                    }
                    StreamUtils.closeQuietly(bufferReader);
                }
                catch (IOException e) {
                    LOGGER.error("error when loadSdkConfigFile, ex:", (Throwable)e);
                }
                finally {
                    StreamUtils.closeQuietly(bufferReader);
                }
                if (script.length() <= 0) continue;
                YopFileSdkConfig sdkConfig0 = JsonUtils.loadFrom(script.toString(), YopFileSdkConfig.class);
                sdkConfig = BeanUtils.merge(sdkConfig0, sdkConfig);
            }
        }
        catch (IOException e) {
            LOGGER.error("error when loadSdkConfigFile, ex:", (Throwable)e);
        }
        return sdkConfig;
    }

    private YopSdkConfig convertYopSdkConfig(YopFileSdkConfig yopFileSdkConfig) {
        YopSdkConfig yopSdkConfig = new YopSdkConfig();
        yopSdkConfig.setServerRoot(yopFileSdkConfig.getServerRoot());
        yopSdkConfig.setYosServerRoot(yopFileSdkConfig.getYosServerRoot());
        yopSdkConfig.setPreferredServerRoots(yopFileSdkConfig.getPreferredServerRoots());
        yopSdkConfig.setPreferredYosServerRoots(yopFileSdkConfig.getPreferredYosServerRoots());
        yopSdkConfig.setSandboxServerRoot(yopFileSdkConfig.getSandboxServerRoot());
        yopSdkConfig.setYopPublicKey(yopFileSdkConfig.getYopPublicKey());
        yopSdkConfig.setTrustAllCerts(yopFileSdkConfig.getTrustAllCerts());
        yopSdkConfig.setProxy(yopFileSdkConfig.getProxy());
        yopSdkConfig.setRegion(yopFileSdkConfig.getRegion());
        yopSdkConfig.setYopHttpClientConfig(yopFileSdkConfig.getHttpClient());
        yopSdkConfig.setYopCertStore(yopFileSdkConfig.getYopCertStore());
        yopSdkConfig.setYopReportConfig(yopFileSdkConfig.getYopReportConfig());
        return yopSdkConfig;
    }

    public Map<String, YopFileSdkConfig> getSdkConfigs() {
        return this.sdkConfigs;
    }

    public void removeConfig(String key) {
        this.sdkConfigs.remove(key);
    }

    public static YopFileSdkConfigProvider instance() {
        return INSTANCE;
    }
}

