/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.yeepay.yop.sdk.utils.RandomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RouteUtils {
    public static <T> List<T> randomList(List<T> origin) {
        ArrayList<T> tmp = new ArrayList<T>(origin);
        Collections.shuffle(tmp, RandomUtils.secureRandom());
        return tmp;
    }

    public static <T> T randomOne(List<T> origin) {
        return origin.get(RandomUtils.secureRandom().nextInt(origin.size()));
    }

    public static <T> List<WeightAble<T>> weightList(List<WeightAble<T>> origin) {
        int total = origin.stream().filter(d -> d.getWeight() > 0).mapToInt(WeightAble::getWeight).sum();
        if (total > 0) {
            int random = RandomUtils.secureRandom().nextInt(total);
            int accumulator = 0;
            ArrayList<WeightAble<T>> tmp = new ArrayList<WeightAble<T>>(origin);
            WeightAble choosed = null;
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                WeightAble dc = (WeightAble)iterator.next();
                if (dc.getWeight() <= 0 || random >= (accumulator += dc.getWeight())) continue;
                choosed = dc;
                iterator.remove();
                break;
            }
            if (null != choosed) {
                tmp.add(0, choosed);
                return tmp;
            }
        }
        return RouteUtils.randomList(origin);
    }

    public static class WeightAble<T> {
        private T t;
        private int weight;

        public WeightAble(T t, int weight) {
            this.t = t;
            this.weight = weight;
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }
}

