/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.request;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.FileParam;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.utils.CheckUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class YopRequest
extends BaseRequest {
    private static final long serialVersionUID = -1L;
    private String apiUri;
    private String httpMethod;
    private final Multimap<String, String> parameters = ArrayListMultimap.create();
    private final Multimap<String, Object> multipartFiles = ArrayListMultimap.create();
    private Object content;

    public YopRequest(String apiUri, String httpMethod) {
        CheckUtils.checkApiUri(apiUri);
        this.apiUri = apiUri;
        this.httpMethod = httpMethod;
    }

    public YopRequest(String apiUri, String httpMethod, YopRequestConfig requestConfig) {
        super(requestConfig);
        CheckUtils.checkApiUri(apiUri);
        this.apiUri = apiUri;
        this.httpMethod = httpMethod;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Multimap<String, String> getParameters() {
        return this.parameters;
    }

    public Multimap<String, Object> getMultipartFiles() {
        return this.multipartFiles;
    }

    public Object getContent() {
        return this.content;
    }

    public YopRequest addParameter(String name, String value) {
        this.validateParameter(name, value);
        this.parameters.put((Object)name, (Object)value);
        return this;
    }

    public YopRequest addEncryptParameter(String name, String value) {
        this.addParameter(name, value);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest addParameters(String name, List<String> values) {
        this.validateParameter(name, values);
        this.parameters.putAll((Object)name, values);
        return this;
    }

    public YopRequest addEncryptParameters(String name, List<String> values) {
        this.addParameters(name, values);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest addParameter(String name, Object value) {
        this.validateParameter(name, value);
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                if (o == null) continue;
                this.parameters.put((Object)name, (Object)o.toString());
            }
        } else if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(value, i);
                if (o == null) continue;
                this.parameters.put((Object)name, (Object)o.toString());
            }
        } else {
            this.parameters.put((Object)name, (Object)value.toString());
        }
        return this;
    }

    public YopRequest addEncryptParameter(String name, Object value) {
        this.addParameter(name, value);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest addMutiPartFile(String name, File file) {
        this.validateParameter(name, file);
        this.multipartFiles.put((Object)name, (Object)file);
        return this;
    }

    public YopRequest addEncryptMutiPartFile(String name, File file) {
        this.addMutiPartFile(name, file);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest addMultiPartFile(String name, InputStream inputStream) {
        this.validateParameter(name, inputStream);
        this.multipartFiles.put((Object)name, (Object)this.restartStream(inputStream));
        return this;
    }

    public YopRequest addMultiPartFile(String name, InputStream inputStream, String fileExtName) {
        this.validateParameter(name, inputStream);
        this.multipartFiles.put((Object)name, (Object)new FileParam(this.restartStream(inputStream), fileExtName));
        return this;
    }

    private InputStream restartStream(InputStream inputStream) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return RestartableInputStream.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw new YopClientException("ReqParam Illegal, InputStreamParam Cant Restart, ex:", (Throwable)e);
        }
    }

    public YopRequest addEncryptMultiPartFile(String name, InputStream inputStream) {
        this.addMultiPartFile(name, inputStream);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest addEncryptMultiPartFile(String name, InputStream inputStream, String fileExtName) {
        this.addMultiPartFile(name, inputStream, fileExtName);
        this.getRequestConfig().addEncryptParam(name);
        return this;
    }

    public YopRequest setContent(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            throw new YopClientException("ReqParam Illegal, RequestContent Is Empty");
        }
        this.content = content;
        return this;
    }

    public YopRequest setEncryptContent(String content) {
        this.setContent(content);
        this.getRequestConfig().addEncryptParam("$").setTotalEncrypt(true);
        return this;
    }

    public YopRequest setEncryptContent(String content, Set<String> jsonPaths) {
        this.setContent(content);
        boolean totalEncrypt = JsonUtils.isTotalEncrypt(jsonPaths);
        this.getRequestConfig().addEncryptParams(totalEncrypt ? YopConstants.TOTAL_ENCRYPT_PARAMS : jsonPaths).setTotalEncrypt(totalEncrypt);
        return this;
    }

    public YopRequest setStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new YopClientException("ReqParam Illegal, InputStreamParam IsNull.");
        }
        this.content = this.restartStream(inputStream);
        return this;
    }

    public YopRequest setEncryptStream(InputStream inputStream) {
        this.setStream(inputStream);
        this.getRequestConfig().addEncryptParam("$").setTotalEncrypt(true);
        return this;
    }

    public YopRequest withApiUri(String apiUri) {
        CheckUtils.checkApiUri(apiUri);
        this.apiUri = apiUri;
        return this;
    }

    public YopRequest withHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Override
    public String getOperationId() {
        return this.apiUri;
    }
}

