package com.ykcloud.soa.social.distribution.api.exception;

import com.gb.soa.omp.ccommon.api.exception.AbstractExceptionType;
import com.gb.soa.omp.ccommon.api.exception.ExceptionTypeCategory;

public class SocialDistributionExceptionType extends AbstractExceptionType {
	//校验request参数
	public static SocialDistributionExceptionType VCE1060001 = new SocialDistributionExceptionType(-1060001, ExceptionTypeCategory.VALIDATE_CLIENT_EXCEPTION, SubSystem.SOCIAL_DISTRIBUTION, "social-distribution系统参数验证异常！");

	//业务异常
	public static SocialDistributionExceptionType VBE2060001 = new SocialDistributionExceptionType(-2060001, ExceptionTypeCategory.VALIDATE_BUSINESS_EXCEPTION, SubSystem.SOCIAL_DISTRIBUTION, "social-distribution系统业务异常！");

	//数据库异常
	public static SocialDistributionExceptionType DOE3060001 = new SocialDistributionExceptionType(-3060001, ExceptionTypeCategory.DATABASE_OPERATE_EXCEPTION, SubSystem.SOCIAL_DISTRIBUTION, "social-distribution系统数据库操作异常！");

	//业务异常
	public static SocialDistributionExceptionType BE4060001 = new SocialDistributionExceptionType(-4060001, ExceptionTypeCategory.BUSINESS_EXCEPTION, SubSystem.SOCIAL_DISTRIBUTION, "social-distribution业务异常！");

	// 构造方法
	private SocialDistributionExceptionType(long code, ExceptionTypeCategory category, String subSystem, String description) {
		super(code, category, subSystem, description);
		SocialDistributionExceptionType.lookup.put(code, this);
	}

	// 初始化异常类
	public static SocialDistributionExceptionType INSTANCE = VCE1060001;

	private static class SubSystem {
		public static String SOCIAL_DISTRIBUTION = "social-distribution";
	}

	@Override
    public AbstractExceptionType getAbstractExceptionTypeByCode(long code) {
		return lookup.get(code);
	}
}
