package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

public class CashOutStatus implements Serializable {

    private static final long serialVersionUID = -126844013125973607L;

    @ApiField(description = "申请流水号")
    @NotNull(message = "申请流水号不能为空")
    private String reservedNo;

    @ApiField(description = "提现状态 1.待审核 2.审核中 3.已审核 9.审核失败")
    @NotNull(message = "提现状态不能为空")
    private Integer statusNumId;

    @ApiField(description = "实际提现金额")
    private Double actualCashOutAmount;

    @ApiField(description = "实际提现时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date actualCashOutDtme;

    @ApiField(description = "外部提现流水号")
    private String thirdReservedNo;

    @ApiField(description = "备注：提现失败原因")
    private String remark;

    @ApiField(description = "错误信息")
    private String errMsg;

    public String getReservedNo() {
        return reservedNo;
    }

    public void setReservedNo(String reservedNo) {
        this.reservedNo = reservedNo;
    }

    public Integer getStatusNumId() {
        return statusNumId;
    }

    public void setStatusNumId(Integer statusNumId) {
        this.statusNumId = statusNumId;
    }

    public Double getActualCashOutAmount() {
        return actualCashOutAmount;
    }

    public void setActualCashOutAmount(Double actualCashOutAmount) {
        this.actualCashOutAmount = actualCashOutAmount;
    }

    public Date getActualCashOutDtme() {
        return actualCashOutDtme;
    }

    public void setActualCashOutDtme(Date actualCashOutDtme) {
        this.actualCashOutDtme = actualCashOutDtme;
    }

    public String getThirdReservedNo() {
        return thirdReservedNo;
    }

    public void setThirdReservedNo(String thirdReservedNo) {
        this.thirdReservedNo = thirdReservedNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
