package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DailyTotalOrderAmount implements Serializable {

    private static final long serialVersionUID = 5251292612555993168L;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiField(description = "日期")
    private Date date;//日期 yyyy-MM-dd

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiField(description = "日期")
    private String dailyDate;//日期 yyyy-MM-dd

    @ApiField(description = "本日订单金额")
    private Double dailyTotalOrderAmount = 0D;//本日订单金额

    @ApiField(description = "本日销售金额")
    private Double dailyTotalSalePerformanceAmount = 0D;//本日销售金额
}
