package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DistributionAccountDetail implements Serializable {

    private static final long serialVersionUID = 4036576760310408774L;

    @ApiField(description = "流水号")
    private String reservedNo;//流水号

    @ApiField(description = "收支金额")
    private Double account;//收支金额

    @ApiField(description = "会员编号")
    private Long leaderUsrNumId;//会员编号

    @ApiField(description = "雇员编号")
    private Long empeNumId;//雇员编号

    @ApiField(description = "绑定订单号")
    private String bindReservedNo;//绑定订单号

    @ApiField(description = "收支类型 1.分销佣金 2.分销邀请佣金 3.网格员销售佣金 4.网格员线索佣金")
    private Integer typeNumId;//收支类型 1.分销佣金 2.分销邀请佣金 3.网格员销售佣金 4.网格员线索佣金

    @ApiField(description = "收支类型名称")
    private String typeName;//收支类型名称

    @ApiField(description = "备注")
    private String remark;//备注

    @ApiField(description = "收入状态 1：预计收入 2：确认收入")
    private Integer statusNumId;//收入状态 1：预计收入 2：确认收入

    @ApiField(description = "创建时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date createDtme;//创建时间

    @ApiField(description = "支付方式")
    private Long payTypeId;//支付方式

    @ApiField(description = "支付方式名称")
    private String payTypeName;//支付方式名称

    @ApiField(description = "余额")
    private String balance;//余额

}
