package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class DistributionCashOutDtl implements Serializable {

    private static final long serialVersionUID = -4699528672636801636L;

    @ApiField(description = "提现流水号")
    private Long reservedNo;//提现流水号

    @ApiField(description = "提现金额")
    private Double cashOutAmount;//提现金额

    @ApiField(description = "个人所得税金额")
    private Double taxAmount;//个人所得税金额

    @ApiField(description = "申请时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyDtme;//申请时间

    @ApiField(description = "审核开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date reviewBeginDtme;//审核开始时间

    @ApiField(description = "审核时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date reviewDtme;//审核时间

    @ApiField(description = "审核人")
    private String reviewer;//审核人

    @ApiField(description = "审核状态 1.待审核 2.审核中 3.已审核 9.审核失败")
    private Integer statusNumId;//审核状态 1.待审核 2.审核中 3.已审核 9.审核失败

    @ApiField(description = "提现进度")
    private List<CashOutProgress> cashOutProgressList;//提现进度

    @ApiField(description = "中金账号")
    private String zjAccountId;

    @ApiField(description = "收款人名称")
    private String payeeName;

    @ApiField(description = "银行名称")
    private String bankName;

    @ApiField(description = "银行账号")
    private String bankAccountId;//银行账号

    @ApiField(description = "身份证号")
    private String idNumber;//身份证号

    @ApiField(description = "手机号")
    private String mobilePhone;//手机号

    @ApiField(description = "实际提现时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualCashOutDtme;//实际提现时间

    @ApiField(description = "实际提现金额")
    private Double actualCashOutAmount;//实际提现金额

    @ApiField(description = "绑卡流水号")
    private String zjBankAccountBindNo;//中金账号与银行卡绑定流水号

    @ApiField(description = "会员编号")
    private Long leaderUsrNumId;//会员编号

    @ApiField(description = "备注")
    private String remark;
}
