package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class DistributionCustomerInfo implements Serializable {

    private static final long serialVersionUID = -8753131744335952981L;

    @ApiField(description = "上级KOC会员编号")
    private Long leaderUsrNumId;

    @ApiField(description = "上级网格员编号")
    private Long empeNumId;

    @ApiField(description = "会员编号")
    private Long usrNumId;//会员编号

    @ApiField(description = "会员名称")
    private String usrName;//会员名称

    @ApiField(description = "会员名称")
    private String customerName;//会员名称(老接口冗余字段)

    @ApiField(description = "会员手机号")
    private String mobilePhone;//会员手机号

    @ApiField(description = "KOC等级")
    private Long salespersonGradeNumId;//KOC等级

    @ApiField(description = "KOC等级名称")
    private String salespersonGradeName;//KOC等级名称

    @ApiField(description = "消费金额")
    private Double totalOrderAmount;//消费金额

    @ApiField(description = "标签集合")
    private List<UsrTag> labels;//标签集合

    @ApiField(description = "头像")
    private String logo;//头像

    @ApiField(description = "是否KOC  0.否  1.是")
    private Integer userSalespersonSign;//是否KOC  0.否  1.是

    @ApiField(description = "微信号")
    private String wxNumber;//微信号

    @ApiField(description = "订单数")
    private  Integer totalOrderCount;//订单数

    @ApiField(description = "客单价")
    private Double perOrderSales;//客单价

    @ApiField(description = "最近下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date finalTradingTime;//最近下单时间 yyyy-MM-dd HH:mm:ss

    @ApiField(description = "地址")
    private String address;//地址

    @ApiField(description = "省份编号")
    private Long   prvNumId;//省份编号

    @ApiField(description = "省份名称")
    private String prvName	;//省份名称

    @ApiField(description = "城市编号")
    private Long  cityNumId;//城市编号

    @ApiField(description = "城市名称")
    private String  cityName;//城市名称

    @ApiField(description = "县(区)编号")
    private Long   cityAreaNumId;//县(区)编号

    @ApiField(description = "县(区)名称")
    private String cityAreaName;//县(区)名称

}
