package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DistributionCustomerOrder implements Serializable {

    private static final long serialVersionUID = 2331379326601627068L;

    @ApiField(description = "订单编号")
    private String tmlNumId;//订单编号

    @ApiField(description = "订单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date orderDate;//订单时间

    @ApiField(description = "KOC手机号")
    private String mobilePhone;//KOC手机号（用户账号）

    @ApiField(description = "会员编号")
    private Long usrNumId;//KOC会员编号

    @ApiField(description = "KOC会员名称")
    private String usrName;//KOC会员名称

    @ApiField(description = "订单金额")
    private Double totalOrderAmount;//订单金额

    @ApiField(description = "销售业绩金额,扣除优惠价积分")
    private Double totalSalePerformanceAmount;

    @ApiField(description = "分佣金额")
    private Double totalCommissionAmount;//分佣金额

    @ApiField(description = "分享佣金金额")
    private Double commissionAmount;

    @ApiField(description = "上级邀请佣金")
    private Double inviteCommissionAmount1;

    @ApiField(description = "上上级邀请佣金")
    private Double inviteCommissionAmount2;

    @ApiField(description = "销售佣金金额")
    private Double saleCommissionAmount;

    @ApiField(description = "线索佣金金额")
    private Double  clueCommissionAmount;

    @ApiField(description = "订单状态")
    private Long operateStatusNumId;//订单状态

    @ApiField(description = "订单状态名称")
    private String operateStatusName;//订单状态名称

    @ApiField(description = "订单来源")
    private Long channelNumId;//订单来源

    @ApiField(description = "订单来源名称")
    private String channelName;//订单来源名称

    @ApiField(description = "支付方式")
    private Long payTypeId;//支付方式

    @ApiField(description = "支付方式名称")
    private String payTypeName;//支付方式名称
}
