package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DistributionOrderProfitDetail implements Serializable {

    private static final long serialVersionUID = 7610435785706641005L;

    @ApiField(description = "订单编号")
    private String tmlNumId;//订单编号

    @ApiField(description = "订单时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date orderDate;//订单时间

    @ApiField(description = "订单金额")
    private Double orderAmount;//订单金额

    @ApiField(description = "销售业绩金额")
    private Double salePerformanceAmount;//销售业绩金额

    @ApiField(description = "分佣金额")
    private Double commissionAmount;//分佣金额

    @ApiField(description = "到账状态 0.未到账 1.已到账")
    private Integer arrivalStatus;//到账状态 0.未到账 1.已到账

    @ApiField(description = "收入状态 1：预计收入 2：确认收入")
    private Integer statusNumId;//收入状态 1：预计收入 2：确认收入
}
