package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DistributionProductCommission implements Serializable {

    private static final long serialVersionUID = -9047366822553072452L;

    @ApiField(description = "规则编号")
    private Long ruleNumId;//规则编号

    @ApiField(description = "电商门店编号")
    private Long ecShopNumId;//电商门店编号

    @ApiField(description = "公司编号")
    private Long cortNumId;//公司编号

    @ApiField(description = "商品sku编码")
    private Long itemNumId;//商品sku编码

    @ApiField(description = "商品sku外部编码")
    private String itemId;//商品sku外部编码

    @ApiField(description = "商品后台分类-中类")
    private Long pty2NumId;//商品后台分类-中类

    @ApiField(description = "提成类型: 1.按销售额比例% 2.按可分配比例 3.按固定金额")
    private Integer commissionType;//提成类型: 1.按销售额比例% 2.按可分配比例 3.按固定金额

    @ApiField(description = "政策类型: 1.临时 2.长期")
    private Integer policyType;//政策类型: 1.临时 2.长期

    @ApiField(description = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginDtme;

    @ApiField(description = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endDtme;

    @ApiField(description = "总提成比例%/金额")
    private Double totalCommissionRatio;//总提成比例%/金额

    @ApiField(description = "销售提成比例%/金额")
    private Double saleCommissionRatio;//销售提成比例%/金额

    @ApiField(description = "线索提成比例%/金额")
    private Double clueCommissionRatio;//线索提成比例%/金额

    @ApiField(description = "总提成金额")
    private Double totalCommissionAmount;//总提成金额

    @ApiField(description = "销售提成金额")
    private Double saleCommissionAmount;//销售提成金额

    @ApiField(description = "线索提成金额")
    private Double clueCommissionAmount;//线索提成金额

    @ApiField(description = "采购价")
    private Double costPrice;//采购价

    @ApiField(description = "最低价格")
    private Double minSalePrice;//最低价格

    @ApiField(description = "零售价")
    private Double price;

    @ApiField(description = "可分配比例%")
    private Double totalDistributionProfitRate;//可分配比例%
}
