package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DistributionSalespersonInfo implements Serializable {

    private static final long serialVersionUID = 5008054771013839392L;

    @ApiField(description = "分销员编码")
    private Long leaderUsrNumId;//分销员编码
    @ApiField(description = "分销员姓名")
    private String leaderUsrName;//分销员名称
    @ApiField(description = "手机号")
    private String mobilePhone;//手机号
    @ApiField(description = "KOC会员头像")
    private String leaderUsrLogo;//分销员头像
    @ApiField(description = "分销等级编号")
    private Long salespersonGradeNumId; // 分销等级编号
    @ApiField(description = "分销等级名称")
    private String salespersonGradeName; // 分销等级名称
    @ApiField(description = "邀请会员编号(上线)")
    private Long inviteSalespersonUsrNumId;//邀请KOC会员编号(上线)
    @ApiField(description = "邀请KOC会员名称")
    private String inviteSalespersonName;//邀请KOC会名称
    @ApiField(description = "邀请KOC会员手机号")
    private String inviteSalespersonMobilePhone;//邀请KOC会员

    @ApiField(description = "邀请网格员编号(上线)")
    private Long inviteSalespersonEmpeNumId;//邀请网格员编号(上线)
    @ApiField(description = "邀请网格员编号(上线)")
    private String inviteSalespersonEmpeName;//邀请网格员名称
    @ApiField(description = "邀请网格员编号(上线)")
    private String inviteSalespersonEmpeMobilePhone;//邀请网格员手机号

    @ApiField(description = "所属网格编号")
    private Long gridNumId;//所属网格编号
    @ApiField(description = "所属网格名称")
    private String gridName;//所属网格名称
    @ApiField(description = "累计收益")
    private Double totalCommissionAmount;//累计收益
    @ApiField(description = "累计客户人数")
    private Long totalCustomerCount;//累计客户人数
    @ApiField(description = "累计邀请人数")
    private Long totalInviteCount;//累计邀请人数
    @ApiField(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDtme;//创建时间
    @ApiField(description = "最后修改操作人")
    private String lastUpdateUserName;//最后修改操作人
    @ApiField(description = "审核状态 1:待审核 3:已同意 4:已拒绝")
    private Integer applyStatusNumId;//审核状态 1:待审核 3:已同意 4:已拒绝
    @ApiField(description = "可提现金额")
    private Double availableIncomeAmount;

    @ApiField(description = "上级分销员信息")
    private DistributionSalespersonInfo inviteDistributionSalespersonInfo;

    @ApiField(description = "是否是分销员 1.是  0 否")
    private Integer salespersonSign;//是否是分销员 1.是  0 否

}
