package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class MonthlyTotalOrderAmount implements Serializable {

    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    @ApiField(description = "日期")
    private Date date;//日期 yyyy-MM

    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    @ApiField(description = "日期")
    private String monthlyDate;//日期 yyyy-MM

    @ApiField(description = "本月订单金额")
    private Double monthlyTotalOrderAmount = 0D;//本月订单金额

    @ApiField(description = "本月销售金额")
    private Double monthlyTotalSalePerformanceAmount = 0D;//本月销售业绩金额
}
