
package com.ykcloud.soa.social.distribution.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;

import java.io.Serializable;
import java.util.List;

/**
 */
public class ParentShowOrderDetail implements Serializable{
	
	private static final long serialVersionUID = 3617286052103253968L;

	//商品id	
	@ApiField(description="商品id	")
	private Long itemNumId;
	
	//商品的图片url
	@ApiField(description="商品的图片url")
	private String itemPicture ="";
	
	//商品数量
	private Double qty;

    @ApiField(description = "可取消数量")
    private Double remainCancelQty;// 可退货数量（lockQty-stopQty-shipQty）
	
	//商品名称 
	@ApiField(description="商品名称 ")
	private String itemName = "";
	
	private Double tradeAmount;
	
	private Double totalTradeAmount;//trade_price*qty
	
	private String specNatureInfo = "";//sku描述
	
	private String series;
	
	private Double tradePrice;
	
	private Double retailPrice;

	private Long pmtSign;

	// 默认值为0、 1 全部评价 、 2全部追评
	private Integer commentType = 0;

    private String subTpid;//淘宝子单号,小程序APP是为0是主商品，不为0是辅料关联的商品
    private List<MaterialProperty> materialPropertyList;//辅料属性
    private String materialProperty;//辅料属性-json字符串

    private Double commissionRatio;//销售佣金比例
    private Double commissionAmount;//销售佣金金额
    private Integer commissionTypeNumId;//佣金类型,佣金类型1.网格员/KOC销售佣金 2.网格员线索佣金 3.KOC邀请佣金
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String shipTimeBegin;
    private String itemPtyName;//商品中类
    private Long clueNumId;//商品线索编号
	public Integer getCommentType() {
		return commentType;
	}

	public void setCommentType(Integer commentType) {
		this.commentType = commentType;
	}

	public String getSubTpid() {
        return subTpid;
    }

    public void setSubTpid(String subTpid) {
        this.subTpid = subTpid;
    }

    public List<MaterialProperty> getMaterialPropertyList() {
        return materialPropertyList;
    }

    public void setMaterialPropertyList(List<MaterialProperty> materialPropertyList) {
        this.materialPropertyList = materialPropertyList;
    }

    public String getMaterialProperty() {
        return materialProperty;
    }

    public void setMaterialProperty(String materialProperty) {
        this.materialProperty = materialProperty;
    }



    /**
	 * 获得itemNumId
	 * @return Long
	 */
	public Long getItemNumId() {
		return itemNumId;
	}

	/**
	 * 设置itemNumId
	 * @param itemNumId
	 */
	public void setItemNumId(Long itemNumId) {
		this.itemNumId = itemNumId;
	}

	/**
	 * 获得itemPicture
	 * @return String
	 */
	public String getItemPicture() {
		return itemPicture;
	}

	/**
	 * 设置itemPicture
	 * @param itemPicture
	 */
	public void setItemPicture(String itemPicture) {
		this.itemPicture = itemPicture;
	}

	/**
	 * 获得itemName
	 * @return String
	 */
	public String getItemName() {
		return itemName;
	}

	/**
	 * 设置itemName
	 * @param itemName
	 */
	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	/**
	 * 获得tradeAmount
	 * @return Double
	 */
	public Double getTradeAmount() {
		return tradeAmount;
	}

	/**
	 * 设置tradeAmount
	 * @param tradeAmount
	 */
	public void setTradeAmount(Double tradeAmount) {
		this.tradeAmount = tradeAmount;
	}

	/**
	 * 获得totalTradeAmount
	 * @return Double
	 */
	public Double getTotalTradeAmount() {
		return totalTradeAmount;
	}

	/**
	 * 设置totalTradeAmount
	 * @param totalTradeAmount
	 */
	public void setTotalTradeAmount(Double totalTradeAmount) {
		this.totalTradeAmount = totalTradeAmount;
	}

	/**
	 * 获得specNatureInfo
	 * @return String
	 */
	public String getSpecNatureInfo() {
		return specNatureInfo;
	}

	/**
	 * 设置specNatureInfo
	 * @param specNatureInfo
	 */
	public void setSpecNatureInfo(String specNatureInfo) {
		this.specNatureInfo = specNatureInfo;
	}

	/**
	 * 获得qty
	 * @return Long
	 */
	public Double getQty() {
		return qty;
	}

	/**
	 * 设置qty
	 * @param qty
	 */
	public void setQty(Double qty) {
		this.qty = qty;
	}

	/**
	 * 获得series
	 * @return String
	 */
	public String getSeries() {
		return series;
	}

	/**
	 * 设置series
	 * @param series
	 */
	public void setSeries(String series) {
		this.series = series;
	}

	/**
	 * 获得tradePrice
	 * @return Double
	 */
	public Double getTradePrice() {
		return tradePrice;
	}

	/**
	 * 设置tradePrice
	 * @param tradePrice
	 */
	public void setTradePrice(Double tradePrice) {
		this.tradePrice = tradePrice;
	}

	/**
	 * 获得retailPrice
	 * @return Double
	 */
	public Double getRetailPrice() {
		return retailPrice;
	}

	/**
	 * 设置retailPrice
	 * @param retailPrice
	 */
	public void setRetailPrice(Double retailPrice) {
		this.retailPrice = retailPrice;
	}

	public Long getPmtSign() {
		return pmtSign;
	}

	public void setPmtSign(Long pmtSign) {
		this.pmtSign = pmtSign;
	}

    public Double getCommissionRatio() {
        return commissionRatio;
    }

    public void setCommissionRatio(Double commissionRatio) {
        this.commissionRatio = commissionRatio;
    }

    public Double getCommissionAmount() {
        return commissionAmount;
    }

    public void setCommissionAmount(Double commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    public Double getRemainCancelQty() {
        return remainCancelQty;
    }

    public void setRemainCancelQty(Double remainCancelQty) {
        this.remainCancelQty = remainCancelQty;
    }

    public String getShipTimeBegin() {
        return shipTimeBegin;
    }

    public void setShipTimeBegin(String shipTimeBegin) {
        this.shipTimeBegin = shipTimeBegin;
    }

    public Integer getCommissionTypeNumId() {
        return commissionTypeNumId;
    }

    public void setCommissionTypeNumId(Integer commissionTypeNumId) {
        this.commissionTypeNumId = commissionTypeNumId;
    }

    public String getItemPtyName() {
        return itemPtyName;
    }

    public void setItemPtyName(String itemPtyName) {
        this.itemPtyName = itemPtyName;
    }

    public Long getClueNumId() {
        return clueNumId;
    }

    public void setClueNumId(Long clueNumId) {
        this.clueNumId = clueNumId;
    }
}
