package com.ykcloud.soa.social.distribution.api.model;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author tz.x
 * @date 2021/6/28 9:56
 */
@Data
public class PerformancesStatistics implements Serializable {

    @ApiField(description = "姓名")
    private String personnelName;
    @ApiField(description = "网格等级名称")
    private String gradeName;// 网格等级名称

    @ApiField(description = "本月提成收益")
    private double currentMonthIncome;

    @ApiField(description = "今日销售额")
    private double todaySalesAmount;

    @ApiField(description = "月度业绩指标")
    private double monthlyPerformancesIndicator;
    @ApiField(description = "月度业绩")
    private double monthlyPerformances;
    @ApiField(description = "月度业绩完成率")
    private double monthlyPerformancesCompletionRate;
    @ApiField(description = "月度KOC招募指标")
    private double kocIndicator;
    @ApiField(description = "KOC招募数")
    private int kocRecruit;
    @ApiField(description = "今日KOC招募数")
    private int toDayKocRecruit;
    @ApiField(description = "KOC招募完成率")
    private double kocRecruitCompletionRate;
    @ApiField(description = "月度会员招募指标")
    private double vipIndicator;
    @ApiField(description = "会员招募数")
    private int vipRecruit;
    @ApiField(description = "今日会员招募数")
    private int toDayVipRecruit;
    @ApiField(description = "会员招募完成率")
    private double vipRecruitCompletionRate;

    @ApiField(description = "上门数")
    private int door;

    @ApiField(description = "完成工单")
    private int doneWorkOrder;

    @ApiField(description = "完成工单完成率")
    private double doneWorkOrderCompletionRate;

    @ApiField(description = "销售线索登记指标")
    private double saleClueRegisterIndicator;
    @ApiField(description = "销售线索登记")
    private int saleClueRegister;

    @ApiField(description = "销售线索登记完成率")
    private double saleClueRegisterCompletionRate;

}
