package com.ykcloud.soa.social.distribution.api.request;


import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import com.ykcloud.soa.social.distribution.api.model.BatchUpdateAnnualIndicator;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Package: com.gb.soa.fullchannel.cmember.api.request
 * @ClassName: BatchUpdateAnnualIndicatorRequest
 * @Author: Dan
 * @Date: 2021/6/26 14:15
 */
@Data
public class BatchUpdateAnnualIndicatorRequest extends AbstractUserSessionRequest {
    private static final long serialVersionUID = -588811416838204784L;
    private List<BatchUpdateAnnualIndicator> userList;

    @NotNull(message = "指标类型不能为空!")
    private Long indicatorTypeNumId;

    @NotNull(message = "指标年不能为空!")
    private String year;

    @ApiField(description = "年度指标")
    private Double yearIndicator;
    @ApiField(description = "月度指标1")
    private Double janIndicator;
    @ApiField(description = "月度指标2")
    private Double febIndicator;
    @ApiField(description = "月度指标3")
    private Double marIndicator;
    @ApiField(description = "月度指标4")
    private Double aprIndicator;
    @ApiField(description = "月度指标5")
    private Double mayIndicator;
    @ApiField(description = "月度指标6")
    private Double junIndicator;
    @ApiField(description = "月度指标7")
    private Double julIndicator;
    @ApiField(description = "月度指标8")
    private Double augIndicator;
    @ApiField(description = "月度指标9")
    private Double sepIndicator;
    @ApiField(description = "月度指标10")
    private Double octIndicator;
    @ApiField(description = "月度指标11")
    private Double novIndicator;
    @ApiField(description = "月度指标12")
    private Double decIndicator;
}
