package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class DistributionCashOutDetailListQueryRequest extends AbstractUserSessionRequest {

    private static final long serialVersionUID = -8550277355715812322L;

    @ApiField(description = "会员编号")
    private Long leaderUsrNumId;

    @ApiField(description = "审核状态 1.待审核 2.审核中 3.已审核 9.审核失败")
    private Integer statusNumId;

    @ApiField(description = "提现流水号")
    private List<String> reservedNos;

    @ApiField(description = "申请开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyBeginDtme;

    @ApiField(description = "申请结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyEndDtme;

    @ApiField(description = "中金账号")
    private String zjAccountId;

    @ApiField(description = "收款人名称")
    private String payeeName;

    @ApiField(description = "银行名称")
    private String bankName;

    @ApiField(description = "银行账号")
    private String bankAccountId;//银行账号

    @ApiField(description = "身份证号")
    private String idNumber;//身份证号

    @ApiField(description = "手机号")
    private String mobilePhone;//手机号

    @ApiField(description = "实际提现开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualCashOutBeginDtme;//实际提现时间

    @ApiField(description = "实际提现结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualCashOutEndDtme;//实际提现时间

    @ApiField(description = "当前页")
    private Integer page = 1;//当前页,默认为1

    @ApiField(description = "每页显示的个数")
    private Integer pageSize = 10;//每页显示的个数，默认为10
}
