package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class DistributionCommissionCashOutRequest extends AbstractRequest {

    private static final long serialVersionUID = -7005293174721867141L;

    @ApiField(description = "分销会员编号")
    @NotNull(message = "分销会员编号不能为空！")
    private Long leaderUsrNumId;

    @ApiField(description = "提现金额")
    @NotNull(message = "提现金额不能为空！")
    private Double cashAmount;

    @ApiField(description = "操作类型：1.预提现 2.实际提现")
    @NotNull(message = "操作类型不能为空！")
    private Integer operateType;
}
