package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * TODO（描述类的职责）
 *
 * @author zy
 * @date 2020/7/20 15:40
 */
@Data
public class DistributionCustomerListQueryRequest extends AbstractRequest {

    private static final long serialVersionUID = 1L;

    @ApiField(description = "分销员编号")
    private Long leaderUsrNumId;//分销员编号

    @ApiField(description = "网格员编号")
    private Long empeNumId;//网格员编号

    @ApiField(description = "网格员编号")
    private Integer sortType = 1;//排序类型：1.按最新下单时间 2.按订单数 3.按订单金额

    @NotNull(message = "时间类型不能为空")
    private Integer timeType;//1.全部 2.今日 3.昨日 4.近7日 5.自定义时间

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDtme;//开始时间 yyyy-MM-dd HH:mm:ss

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDtme;//结束时间yyyy-MM-dd HH:mm:ss

    private String searchKeywords;//搜索关键字：客户手机号或昵称

    private Integer page = 1;//当前页

    private Integer pageSize = 10;//每页显示条数
}
