package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * TODO（描述类的职责）
 *
 * @author zy
 * @date 2020/7/21 10:29
 */
@Data
public class DistributionInviteListQueryRequest extends AbstractRequest {

    private static final long serialVersionUID = 1L;

    @ApiField(description = "KOC会员编号")
    private Long leaderUsrNumId;//KOC会员编号

    @ApiField(description = "网格员编号")
    private Long empeNumId;//网格员编号

    @ApiField(description = "时间类型：1.全部 2.今日 3.昨日 4.近7日 5.自定义时间")
    @NotNull(message = "时间类型不能为空")
    private Integer timeType = 1;//时间类型：1.全部 2.今日 3.昨日 4.近7日 5.自定义时间

    @ApiField(description = "开始时间")
    private Date beginDtme;//开始时间 yyyy-MM-dd HH:mm:ss

    @ApiField(description = "结束时间")
    private Date endDtme;//结束时间 yyyy-MM-dd HH:mm:ss

    @ApiField(description = "当前页")
    private Integer page = 1;//当前页,默认为1

    @ApiField(description = "每页显示的个数")
    private Integer pageSize = 10;//每页显示的个数，默认为10
}
