package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import java.util.Date;

@Data
public class DistributionOrderProfitDetailsQueryRequest extends AbstractRequest {

    private static final long serialVersionUID = 8178742686680861368L;

    @ApiField(description = "KOC会员编号")
    private Long leaderUsrNumId;//KOC会员编号

    @ApiField(description = "网格员编号")
    private Long empeNumId;//网格员编号

    @ApiField(description = "网格员编号")
    private Long customerUsrNumId;//客户会员编号

    @ApiField(description = "时间类型")
    private Integer timeType = 1;//时间类型：1.全部 2.今日 3.昨日 4.近7日 5.自定义时间

    @ApiField(description = "开始时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date beginDtme;//开始时间 yyyy-MM-dd HH:mm:ss

    @ApiField(description = "结束时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date endDtme;//结束时间 yyyy-MM-dd HH:mm:ss

    @ApiField(description = "到账状态")
    private Integer arrivalStatus;//到账状态 0.未到账 1.已到账

    @ApiField(description = "排序类型")
    private Integer sortType = 1;//排序类型：1.按时间 2.按订单金额 3.按提成

    @ApiField(description = "1.正序 2.倒序")
    private Integer sequenceType = 2;//1.正序 2.倒序

    @ApiField(description = "当前页")
    private Integer page = 1;//当前页,默认为1

    @ApiField(description = "每页显示的个数")
    private Integer pageSize = 10;//每页显示的个数，默认为10
}
