package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class DistributionProductCommissionRuleGetRequest extends AbstractRequest {

    private static final long serialVersionUID = -1333791844707176708L;

    @ApiField(description = "商品sku编号")
    @NotNull(message = "商品sku编号不能为空")
    private Long itemNumId;

    @ApiField(description = "商品总售价")
    @NotNull(message = "商品总售价不能为空")
    private Double price;

    @ApiField(description = "计算佣金单价")
    @NotNull(message = "计算佣金单价不能为空")
    private Double commissionPrice;

    @ApiField(description = "采购价")
    private Double costPrice;

    @ApiField(description = "商品数量")
    @NotNull(message = "商品数量不能为空")
    private Double qty;

    @ApiField(description = "电商门店编号")
    private Long ecShopNumId;

    @ApiField(description = "线下门店编号")
    private Long subUnitNumId;

    @ApiField(description = "分销员编号")
    private Long leaderUsrNumId;//分销员编号

    @ApiField(description = "网格员编号")
    private Long empeNumId;//网格员编号
}
