package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;

public class DistributionRankListQueryRequest extends AbstractRequest {
    private static final long serialVersionUID = -7977663959484153816L;

    private Long leadUserNumId;//分销员编号
    private Integer rankType=1;//排行类型 1:按收益排行 2:按销售排行 3:按客户排行,默认1
    @NotNull(message = "统计时间类型不能为空")
    private Integer timeType;//3.昨日 4.近7日 5.自定义时间
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date beginDtme;//开始时间 yyyy-MM-dd HH:mm:ss
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDtme;//结束时间 yyyy-MM-dd HH:mm:ss
    private Integer page=1;//第几页,默认为1
    private Integer pageSize=100;//每页显示的个数，默认为100
    //总店编号和分店编号至少传一个
    private Long headEcShopNumId;//电商总店门店编号
    private Long ecShopNumId;//电商分店门店编号

    public Long getLeadUserNumId() {
        return leadUserNumId;
    }

    public void setLeadUserNumId(Long leadUserNumId) {
        this.leadUserNumId = leadUserNumId;
    }

    public Integer getRankType() {
        return rankType;
    }

    public void setRankType(Integer rankType) {
        this.rankType = rankType;
    }

    public Integer getTimeType() {
        return timeType;
    }

    public void setTimeType(Integer timeType) {
        this.timeType = timeType;
    }

    public Date getBeginDtme() {
        return beginDtme;
    }

    public void setBeginDtme(Date beginDtme) {
        this.beginDtme = beginDtme;
    }

    public Date getEndDtme() {
        return endDtme;
    }

    public void setEndDtme(Date endDtme) {
        this.endDtme = endDtme;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getHeadEcShopNumId() {
        return headEcShopNumId;
    }

    public void setHeadEcShopNumId(Long headEcShopNumId) {
        this.headEcShopNumId = headEcShopNumId;
    }

    public Long getEcShopNumId() {
        return ecShopNumId;
    }

    public void setEcShopNumId(Long ecShopNumId) {
        this.ecShopNumId = ecShopNumId;
    }
}
